/*******************************************************************************
Commands:

AM=x where x =1|0 Sets Mode. Mode 0 = CC, Mode 1 = Flash
AL=XY X=load channel (0-3) Artimes L1, Artemis L2, Bia L1, Bia L2 - Y = 0|1 On or Off
AFY=X.XX Where Y = channel and X.XX = flash rate between 0 and 1
AEY=X where Y = channel and X = 0|1 On or Off
AT = TemP reading
AP = Pressure Reading
AH = Humidty reading

*******************************************************************************/
#include "mbed.h"
#include "BME280.h"
#include "DS1820.h"

#define GPIO1 PB_12

#define GPIO2 PB_9
 
#define GPIO3 PB_8

#define GPIO4 PB_5

#define GPIO5 PB_4

#define GPIO6 PB_3

#define GPIO7 PD_2   //PD_2

#define GPIO8 PC_8

#define GPIO9 PC_7

#define GPIO10 PA_15

#define GPIO11 PC_9

#define GPIO12 PC_6

#define LOAD0 PA_1
#define LOAD1 PA_6

DigitalOut flash0(GPIO1);
DigitalOut flash1(GPIO5);
DigitalOut flash2(GPIO2);
DigitalOut flash3(GPIO6);
DigitalOut flash4(GPIO3);
DigitalOut flash5(GPIO7);
DigitalOut flash6(GPIO4);
DigitalOut flash7(GPIO8);

DigitalOut GPSEnable(GPIO12);

DigitalOut load0(LOAD0);
DigitalOut load1(LOAD0);
DigitalOut SVLoad1(GPIO11);
DigitalOut SVLoad2(GPIO11);

InterruptIn syncLine(PC_13);

float flashStat[32] = {0}; //First 8 are Flash EN, Next 8 are next flash, final 8 are Flash rate.
PwmOut dimming(GPIO10);
DigitalOut flashMode(GPIO9);

BME280 BME280(PB_7, PB_6);

Timer t;

Serial lantronix(PA_2, PA_3);

DS1820 extTemp1(PC_3);
DS1820 extTemp2(PA_7);
DS1820 extTemp3(PA_0);
DS1820 extTemp4(PB_0);

DigitalIn extTemp1Pin(PC_3);
DigitalIn extTemp2Pin(PA_7);
DigitalIn extTemp3Pin(PA_0);
DigitalIn extTemp4Pin(PB_0);

int commandFlag = 0;
int messageProcessFlag = 0;

int debugOut = 0;
float flashrate = 0;

char msgBuffer[20] = {0};
int msgBufferCount = 0;

int singleFlash = 0;

int temploop = 0;

void syncActive(){
//singleFlash = 1;
 int j = 1;
 for(int i = 0; i<8; i++)
 {
    if(flashStat[i])
    {
        switch(i){
            case 0:
            flash0 = j;
                break;
            case 1:
            flash1 = j;
                break;
            case 2:
            flash2 = j;
                break;
            case 3:
            flash3 = j;
                break;
            case 4:
            flash4 = j;
                break;
            case 5:
            flash5 = j;
                break;
            case 6:
            flash6 = j;
                break;
            case 7:
            flash7 = j;
                break;
                }
    }
    if(i == 7)
    {
        wait(0.01);
        flash0 = 0;
        flash1 = 0;
        flash2 = 0;
        flash3 = 0;
        flash4 = 0;
        flash5 = 0;
        flash6 = 0;
        flash7 = 0;
    }
 }
            
}
void sendOK(){
    lantronix.printf("\n\rOK\n\r");
}

void sendERROR(){
    lantronix.printf("\n\rERROR\n\r");
}

void rxCallback() {
    if(commandFlag)
    {
        if(debugOut) lantronix.printf("Command Started \r\n");
        if(lantronix.readable())
        {
            
            msgBuffer[msgBufferCount] = lantronix.getc();
            lantronix.putc(msgBuffer[msgBufferCount]);
            if(msgBuffer[msgBufferCount] == '\n')
            {
                commandFlag = 0;
                msgBuffer[msgBufferCount] = 0;
                messageProcessFlag = 1;
                msgBufferCount = 0;
            }
            if(msgBuffer[msgBufferCount] == 0x7F)
            {
                if(msgBufferCount > 0)
                {
                    msgBufferCount--;
                    if(msgBufferCount > 0)
                    {
                        msgBufferCount--;
                    }
                }
            }
            msgBufferCount++;
            if(msgBufferCount > 9)
            {
                sendERROR();
                msgBufferCount = 0;
                messageProcessFlag = 0;
                commandFlag = 0;
            }
        }
    }
    
    else
    {
            char c;
            temploop = 0;            
            c = lantronix.getc();
            if(c == 'A')
            {
                commandFlag = 1;
                for(int i = 0; i<10; i++)
                {
                    msgBuffer[i] = 0;
                }
                lantronix.putc(c);
                msgBuffer[0] = c;
                msgBufferCount = 1;
            }
            
            
        }
}


    

void setMode(char _flashmode){
    if(_flashmode == '1') flashMode = 1;
    if(_flashmode == '0') flashMode = 0;
}

void setLoad(char _channel, char _loadmode){
    _channel = _channel - 48;
    _loadmode = _loadmode - 48;
    
   // lantronix.printf("Loadmode is %f \r\n", _loadmode)
   // lantronix.printf("Channel is %f \r\n", _channel)
    
    if(_channel == 0) load0 = _loadmode;
    if(_channel == 1) load1 = _loadmode;
    if(_channel == 2) SVLoad1 = _loadmode;
    if(_channel == 3) SVLoad2 = _loadmode;
}

void setFlash(char _channel, char _dig1, char _dig2, char _dig3){
    int number;
    //lantronix.printf("AFR Char = %c.%c%c \r\n", _dig1, _dig2, _dig3);
    flashrate = 0;
    number = _dig1 - 48;
    _channel = _channel - 48;
    if(number == 1)
    {
        flashrate = 1;
        flashStat[_channel+16] = flashrate;
    }
    else
    {
        number = _dig2 - 48;
        flashrate = 0.1*number;
        flashStat[_channel+16] = flashrate;
        if(_dig3 != 13)
        {
            number = _dig3 - 48;
            flashrate = flashrate + 0.01*number;
            flashStat[_channel+16] = flashrate;
        }
    }
    
    if(flashrate > 1) 
    { 
        flashrate = 1.0; 
        flashStat[_channel+16] = flashrate;
    }
    if(flashrate < 0) 
    {
        flashrate = 0.0; 
        flashStat[_channel+16] = flashrate;
    }
    //lantronix.printf("AFR%i=%f", _channel, flashStat[_channel+8]);
}


void messageProcess() {
    switch(msgBuffer[1])
    {
        case 'M' :
            if(msgBuffer[2] == '=')
            {
                setMode(msgBuffer[3]);
                sendOK();
                
            }
            else if(msgBuffer[2] == '?')
            {
                lantronix.printf("\n\rAM=%i\n\r", flashMode.read());
            }
            else sendERROR();
            messageProcessFlag = 0;
            msgBuffer[0] = 0;
            msgBufferCount = 0;
            break;
        case 'L' :
            if(msgBuffer[2] == '=')
            {
                setLoad(msgBuffer[3],msgBuffer[4]);
                sendOK();
            }
            else if(msgBuffer[2] == '?')
            {
                lantronix.printf("\n\rAL=%i\n\r", load0.read());
            }
            else sendERROR();
            messageProcessFlag = 0;
            msgBuffer[0] = 0;
            msgBufferCount = 0;
        
            break;
            
         case 'F' :
            if(msgBuffer[3] == '=')
            {
                if(msgBuffer[5] == '.')
                {
                    //lantronix.printf("\n\rD3=%i\n\r", msgBuffer[6]);
                    setFlash(msgBuffer[2],msgBuffer[4],msgBuffer[6],msgBuffer[7]);
                    sendOK();
                }
                else
                {
                    sendERROR();
                }
            }
            else if(msgBuffer[3] == '?')
            {
                lantronix.printf("\n\rAF=%i\n\r", flash0.read());
            }
            else sendERROR();
            /**
            if(msgBuffer[2] == 'R')
            {
                if(msgBuffer[3] == '=')
                {
                    setFlash(msgBuffer[3]);
                    sendOK();
                }
                if(msgBuffer[3] == '?')
                {
                    lantronix.printf("\n\rAFR=%i\n\r", flashRate);
                }
            }
            **/
            messageProcessFlag = 0;
            msgBuffer[0] = 0;
            msgBufferCount = 0;
        
            break;
        case 'T' :
            if(msgBuffer[2] == 'S')
            {
                temploop = 1;
            }
            
            time_t seconds = time(NULL);
            lantronix.printf("%3.1i,", seconds);
            
            if(extTemp1.isPresent())
            {
                lantronix.printf("Temp1: %3.1f,\n\r", extTemp1.read());
                extTemp1.startConversion();
            }
            if(extTemp2.isPresent())
            {
                lantronix.printf("Temp2: %3.1f,\n\r", extTemp2.read());
                extTemp2.startConversion();
            }
            if(extTemp3.isPresent())
            {
                lantronix.printf("Temp3: %3.1f,\n\r", extTemp3.read());
                extTemp2.startConversion();
            }
            if(extTemp4.isPresent())
            {
                lantronix.printf("Temp4: %3.1f,\n\r", extTemp4.read());
                extTemp2.startConversion();
            }
            lantronix.printf("OB-Temp: %2.2f \n\r", BME280.getTemperature());
            break;
        case 'P' :
            lantronix.printf("Pres: %4.2f kPa\n\r", BME280.getPressure());
            break;
        case 'H' :
           lantronix.printf("Humi: %2.2f %% \n\r", BME280.getHumidity());
            break;
        case 'G' :
            /**
            gps.sample();
            sendOK();
            lantronix.printf("Lat = %.4f ", gps.latitude);
            lantronix.printf("Lon = %.4f \n\r", gps.longitude);
            **/
            break;
        case 'B' :
            if(msgBuffer[2] == '=')
            {
                int dimValue = msgBuffer[3] - 48;
                if(dimValue > 9) dimValue = 9;
                if(dimValue < 0) dimValue = 0;
                
                dimValue = 10 - dimValue;
                dimValue = dimValue / 10;
                if(dimValue = 0) dimValue = 0.01;
                dimming.write(dimValue);
                sendOK();
                
            }
            else if(msgBuffer[3] == '?')
            {
                lantronix.printf("\n\rAD=%i\n\r", dimming.read());
            }
            else sendERROR();
            break;
        case 'E' :
            if(msgBuffer[3] == '=')
            {
                int channel = msgBuffer[2] - 48;
                int enable = msgBuffer[4] - 48;
                if(enable > 1) enable = 0;
                if(enable < 0) enable = 0;
                if(channel < 8)
                {
                    flashStat[channel] = enable;
                    sendOK();
                }
            }
            else if(msgBuffer[3] == '?')
            {
                int channel = msgBuffer[2] - 48;
                lantronix.printf("\n\rAE%i=%i\n\r", channel, flashStat[channel]);
            }
            else sendERROR();
            /**
            if(msgBuffer[2] == 'R')
            {
                if(msgBuffer[3] == '=')
                {
                    setFlash(msgBuffer[3]);
                    sendOK();
                }
                if(msgBuffer[3] == '?')
                {
                    lantronix.printf("\n\rAFR=%i\n\r", flashRate);
                }
            }
            **/
        
            break;
        default :
             sendERROR();
             messageProcessFlag = 0;
             msgBuffer[0] = 0;
             msgBufferCount = 0;
             break;
    }
    messageProcessFlag = 0;
    msgBuffer[0] = 0;
    msgBufferCount = 0;
}



// main() runs in its own thread in the OS
int main() {
    float lastTime = 0;
    float interval = 0;
    
    extTemp1Pin.mode(PullUp);
    extTemp2Pin.mode(PullUp);
    extTemp3Pin.mode(PullUp);
    extTemp4Pin.mode(PullUp);
    
    if(extTemp1.begin())
    {
        extTemp1.startConversion();
    }
    if(extTemp2.begin())
    {
        extTemp2.startConversion();
    }
    if(extTemp3.begin())
    {
        extTemp3.startConversion();
    }
    if(extTemp4.begin())
    {
        extTemp4.startConversion();
    }
    lantronix.baud(9600);
    lantronix.attach(&rxCallback, Serial::RxIrq);
    GPSEnable = 1;
    flashMode = 0;
    load0 = 0;
    dimming.write(0.01);
    dimming.period_us(100);
    flash0 = flash1 = 0;
    t.start();
    wait(2);
    lantronix.printf("Starting Up \n\r");
    float currentTime = 0;
    int delay = 1;
    set_time(0);
    while (true) {
        syncLine.fall(&syncActive);
        if(extTemp1.isPresent())
        {
            extTemp1.startConversion();
        }
        if(extTemp2.isPresent())
        {
            extTemp2.startConversion();
        }
        if(extTemp3.isPresent())
        {
            extTemp3.startConversion();
        }
        if(extTemp4.isPresent())
        {
            extTemp4.startConversion();
        }
        if(temploop)
        {
            if(extTemp1.read() > 110 || extTemp2.read() > 110)
            {
                for(int x=0; x <9; x++)
                {
                    flashStat[x] = 0;
                }
                lantronix.printf("OVERTEMP REACHED END OF TEST \n\r");
                wait(2);
            }
            
            time_t seconds = time(NULL);
            
            if(seconds - lastTime >= delay)
            {
                lastTime = seconds;
                lantronix.printf("%3.1i,", seconds);
                if(extTemp1.isPresent())
                {
                    lantronix.printf("%3.1f,", extTemp1.read());
                }
                if(extTemp2.isPresent())
                {
                    lantronix.printf("%3.1f,", extTemp2.read());
                }
                if(extTemp3.isPresent())
                {
                    lantronix.printf("%3.1f,", extTemp3.read());
                }
                if(extTemp4.isPresent())
                {
                    lantronix.printf("%3.1f \n\r", extTemp4.read());
                }
            }
        }
        /**
        if(singleFlash)
        {
            int j = 1;
            for(int i = 0; i<8; i++)
            {
                if(flashStat[i])
                {
                    switch(i){
                        case 0:
                        flash0 = j;
                            break;
                        case 1:
                        flash1 = j;
                            break;
                        case 2:
                        flash2 = j;
                            break;
                        case 3:
                        flash3 = j;
                            break;
                        case 4:
                        flash4 = j;
                            break;
                        case 5:
                        flash5 = j;
                            break;
                        case 6:
                        flash6 = j;
                            break;
                        case 7:
                        flash7 = j;
                            break;
                            }
                }
                if(i == 7)
                {
                    wait(0.01);
                    flash0 = 0;
                    flash1 = 0;
                    flash2 = 0;
                    flash3 = 0;
                    flash4 = 0;
                    flash5 = 0;
                    flash6 = 0;
                    flash7 = 0;
                    singleFlash = 0;
                }
            }
            
            
        }
        **/
        
        if(messageProcessFlag) messageProcess();
        for(int i = 0; i<8; i++)
        {
            if(flashStat[i])
            {
                interval = (1/flashStat[i+16]) * 7;
                //interval = 500;
                if(flashStat[i+16] == 1)
                {
                    switch(i){
                        case 0:
                        flash0 = 1;
                            break;
                        case 1:
                        flash1 = 1;
                            break;
                        case 2:
                        flash2 = 1;
                            break;
                        case 3:
                        flash3 = 1;
                            break;
                        case 4:
                        flash4 = 1;
                            break;
                        case 5:
                        flash5 = 1;
                            break;
                        case 6:
                        flash6 = 1;
                            break;
                        case 7:
                        flash7 = 1;
                            break;
                    
                    }
                }
                else if(t.read_ms() - flashStat[i+8] > interval)
                {
                    switch(i){
                        case 0:
                        flash0 = !flash0;
                            break;
                        case 1:
                        flash1 = !flash1;
                            break;
                        case 2:
                        flash2 = !flash2;
                            break;
                        case 3:
                        flash3 = !flash3;
                            break;
                        case 4:
                        flash4 = !flash4;
                            break;
                        case 5:
                        flash5 = !flash5;
                            break;
                        case 6:
                        flash6 = !flash6;
                            break;
                        case 7:
                        flash7 = !flash7;
                            break;
                            }
                    flashStat[i+8] = t.read_ms();
                }
            }
            else
            {
                switch(i){
                    case 0:
                    flash0 = 0;
                        break;
                    case 1:
                    flash1 = 0;
                        break;
                    case 2:
                    flash2 = 0;
                         break;
                    case 3:
                    flash3 = 0;
                        break; 
                    case 4:
                    flash4 = 0;
                        break;
                    case 5:
                    flash5 = 0;
                        break;
                    case 6:
                    flash6 = 0;
                         break;
                    case 7:
                    flash7 = 0;
                        break;
                        }
            }
        }
        
    }
}

