#include "mbed.h"
#include "PinAssign.h"
#include "GlobalVars.h"
#include "SwitchFn.h"

Timeout SndStateReq;

bool fReq=1;

void Req_isr(void) {fReq=1;}

int main() 
{
    pc.baud(115200);
    Snd2Crr.baud(9600);
    
    Sw1.mode(PullUp);
    Sw2.mode(PullUp);
    Sw3.mode(PullUp);
    Sw4.mode(PullUp);
    Sw5.mode(PullUp);
    Sw6.mode(PullUp);
    Sw7.mode(PullUp);
    Sw8.mode(PullUp);
    Sw14.mode(PullUp);
    Sw58.mode(PullUp);
    SwAll.mode(PullUp);
    
    myled1=0;
    myled2=0;
    myled3=0;
    myled4=0;
        
    while(1)
    {
        if(fReq==1)
        {
            fReq=0;
            SndStateReq.attach(&Req_isr, 1);
            
            Send2Crr();
            
            
            if(SigBit==RcvBit)
            {
                pc.printf("Good Status\n");
                Led9=1;
            }
            else
            {
                pc.printf("Signal Lost\n");
                Led9=0;
            }
            RcvStat();
            
            pc.printf("%x %x\n",SigBit,RcvBit);
            RcvBit=0;
        }
        if(Sw1==0) Sw1Fn();
        if(Sw2==0) {Sw2Fn();}
        if(Sw3==0) Sw3Fn();
        if(Sw4==0) Sw4Fn();
        if(Sw5==0) Sw5Fn();
        if(Sw6==0) Sw6Fn();
        if(Sw7==0) Sw7Fn();
        if(Sw8==0) Sw8Fn();
        if(Sw14==0) Sw14Fn();
        if(Sw58==0) Sw58Fn();
        if(SwAll==0) {SwAllFn();}
        
        if(Snd2Crr.readable()) ProcCrr();
    }
}