#include "mbed.h"
#include "PinAssign.h"
#include "GlobalVars.h"
#include "Functions.h"

bool fSndTimer=1;
bool fDebugTimer=1;

Timeout SndTimer;
Ticker DebugTimer;
void SndTimer_isr(void) {fSndTimer=1;}
void DebugTimer_isr(void) {fDebugTimer=1;}

int main() 
{
    pc.baud(115200);
    Switch.baud(9600);
    
    InitPWM();
    
    pc.printf("Start\n");
    
    DebugTimer.attach(&DebugTimer_isr,1);
    
    while(1) 
    {   
        if(Switch.readable()) RcvProc();
        
        if(fSndTimer==1)
        {
            fSndTimer=0;
            
            SndPWM();
            SigBit=RcvBit;
            Switch.putc(SigBit);
            
            SndTimer.attach(&SndTimer_isr,0.02);            
        }
        
        if(fDebugTimer==1)
        {
            fDebugTimer=0;
            pc.printf("%d %d %d %d %d %d %d %d\n",(int)var1,(int)var2,(int)var3,(int)var4,(int)var5,(int)var6,(int)var7,(int)var8);
        }
        
        
    }
}
