#include "mbed.h"
#include "PPMIn.h"
#include "Pin_Assign.h"

PpmIn::PpmIn(PinName pin): ppm(pin)//, pc_com(USBTX, USBRX)
{
    //pc_com.printf("Constructor say hi!");
    current_channel = 0;
    state = false;
    timer.start();
    ppm.rise(this, &PpmIn::rise);
       
}

uint16_t* PpmIn::getPpm()
{
    uint16_t* p_out[CHANNELS+2];
    *p_out = &channels[0];
    //pc_com.printf("%d",channels[0]);
    return *p_out;            
}
            
void PpmIn::rise()
{
    uint16_t time = timer.read_us();
    
    //pc.printf("%d\n",time);
    
    //pc_com.printf("Rise say hi!");
    // we are in synchro zone
    if(time > 2500)
    {
       current_channel = 0;
       // return values 
       state = true;
    }
    else
    {
        channels[current_channel] = timer.read_us();  
        current_channel += 1;     
    }
    
    timer.reset();
    
    //if (current_channel > (CHANNELS + 2 - 1)); //+frame and - 1 indexing of channels list
}