#ifndef GLOBAL_VARIABLES_H
#define GLOBAL_VARIABLES_H
#include "mbed.h"

#define ANGLE_UNIT 0.02197265625f    //  degree
#define SPEED_UNIT 0.1220740379f     //  degree/sec

#define IdlePWM 1500
#define dt 0.2f
#define KdY -24.0f
#define KiY -8.0f
#define KpY -8.0f
#define KdP -24.0f
#define KiP -8.0f
#define KpP -8.0f
#define YawLim 100.0f
#define PitchLim 100.0f

extern int16_t YawIMU, PitchIMU, RollIMU, YawTarIMU, PitchTarIMU, RollTarIMU;
extern int32_t YawIMU2, PitchIMU2, RollIMU2;
extern uint16_t YawTarPWM, PitchTarPWM;
extern double YawDeg, PitchDeg, RollDeg, YawTar, PitchTar, RollTar, RollRel, PitchRel, YawRel;
extern uint8_t GimbalBuf[100], GimbalCnt, HeadChks, BodyChks;
extern bool fGET_ANGLE;

extern double ErrorY, ErrorYI, YawI, prevErrorY, YawPWM, YawT;
extern double ErrorP, ErrorPI, PitchI, prevErrorP, PitchPWM, PitchT;

extern uint8_t RFBuf[100], RFCnt, RFHeadChks, RFBodyChks;

extern int16_t rV1, rV2, rV3, rV4, rEle, rAzi, rEle_raw, rAzi_raw, rEle_Offset, rAzi_Offset;
extern float V1, V2, V3, V4, Ele, Azi, Ele_raw, Azi_raw, Ele_Offset, Azi_Offset;
extern uint8_t Pckt[100],fRFread;

//PPM Vars
extern uint16_t YawPPM, PitchPPM, LockPPM;
extern float YawDegCMD, PitchDegCMD;
extern uint8_t fLock;

//pc input cmd
extern char pcPckt[50], pcCnt, pcBuf,fpc;
#endif