#include "mbed.h"
#include "Pin_Assign.h"
#include "Global_Variables.h"
#include "COMMs.h"

void PrsTrk(void)
{
    for(char i=0;i<=63;i++) {MuxPck[i]=TrkPck[i];} //C/P -> 63;
    
    MuxPck[74]=TrkPck[74];
    MuxPck[75]=TrkPck[75];
    MuxPck[76]=TrkPck[76];
    MuxPck[77]=TrkPck[77];
    MuxPck[78]=TrkPck[78];
    MuxPck[79]=TrkPck[79];
}
void GetTrk(void)
{
    unsigned char Trkbuf;
    Trkbuf=Trk.getc();
    
    if(Trkbuf==0xfe&&TrkCnt==0||Trkbuf==0xfe&&TrkCnt==1)        {TrkPck[TrkCnt]=Trkbuf;TrkCnt++;}
    else if(TrkCnt>=2&&TrkCnt<=81)                              {TrkPck[TrkCnt]=Trkbuf;TrkCnt++;}
    else if(Trkbuf==0xff&&TrkCnt==82||Trkbuf==0xff&&TrkCnt==83) {TrkPck[TrkCnt]=Trkbuf;TrkCnt++;}
    else if(TrkCnt==84)                                         {PrsTrk(); TrkCnt=0;}
    else TrkCnt=0;
}

void PrsTrg(void)
{
    MuxPck[64]=TrgPck[19]; //lat
    MuxPck[65]=TrgPck[20];
    MuxPck[66]=TrgPck[21];
    MuxPck[67]=TrgPck[22];
        
    MuxPck[68]=TrgPck[23]; //lon
    MuxPck[69]=TrgPck[24];
    MuxPck[70]=TrgPck[25];
    MuxPck[71]=TrgPck[26];
    MuxPck[72]=TrgPck[27]; //al
    MuxPck[73]=TrgPck[28];
}
void GetTrg(void)
{
    unsigned char Trgbuf;
    Trgbuf=Trg.getc();
    
    if(Trgbuf==0xfe&&TrgCnt==0||Trgbuf==0xfe&&TrgCnt==1)        {TrgPck[TrgCnt]=Trgbuf;TrgCnt++;}
    else if(TrgCnt>=2&&TrgCnt<=81)                              {TrgPck[TrgCnt]=Trgbuf;TrgCnt++;}
    else if(Trgbuf==0xff&&TrgCnt==82||Trgbuf==0xff&&TrgCnt==83) {TrgPck[TrgCnt]=Trgbuf;TrgCnt++;}
    else if(TrgCnt==84)                                         {PrsTrg(); TrgCnt=0;}
    else TrgCnt=0;
}

void PrsPc(void)
{
    for(char i=0;i<=26;i++) {Trk.putc(PcPck[i]);}
}
void GetPc(void)
{
    unsigned char Pcbuf;
    Pcbuf=Pc.getc();
    
    if(Pcbuf==0xfe&&PcCnt==0||Pcbuf==0xfe&&PcCnt==1)            {PcPck[PcCnt]=Pcbuf;PcCnt++;}
    else if(PcCnt>=2&&PcCnt<=24)                                {PcPck[PcCnt]=Pcbuf;PcCnt++;}
    else if(Pcbuf==0xff&&PcCnt==25||Pcbuf==0xff&&PcCnt==26)     {PcPck[PcCnt]=Pcbuf;PcCnt++;}
    else if(PcCnt==27)                                          {PrsPc(); PcCnt=0;}
    else PcCnt=0;
}

void Mux2GCS(void)
{
    int chksum=0;
    for(char ChkCnt=1;ChkCnt<=73;ChkCnt++)
    {
        chksum+=MuxPck[6+ChkCnt];
    }
    MuxPck[80]=chksum/256;
    MuxPck[81]=chksum%256;
    MuxPck[82]=0xff;
    MuxPck[83]=0xff;
    
    for(char i=0;i<=83;i++) {Pc.putc(MuxPck[i]);}
}