#ifndef MBED_BME280_SPI_H
#define MBED_BME280_SPI_H

#include "mbed.h"

class BME280
{
private:
    uint16_t    dig_T1;
    int16_t     dig_T2, dig_T3;
    uint16_t    dig_P1;
    int16_t     dig_P2, dig_P3, dig_P4, dig_P5, dig_P6, dig_P7, dig_P8, dig_P9;
    uint16_t    dig_H1, dig_H3;
    int16_t     dig_H2, dig_H4, dig_H5, dig_H6;
    int32_t     t_fine;
    
public:
    enum spi_mask {
    BME280_MASK = 0x7F
    };
    
    BME280();
    
    //void initialize(void);
    
    float getTemperature(void);
    
    float getPressure(void);
    
    float getHumidity(void);
};

#endif