#include "mbed.h"
#include "bme280.h"

BME280::BME280()
{
    t_fine=0;
    char cmd[18];
    DigitalOut cs(p8);
    SPI spi(p5,p6,p7);
    cs=1;
    spi.format(8, 0); // 8-bit, mode=0
    spi.frequency(1000000); // 1MHZ    
    
    //ctrl_hum
    cs=0;
    spi.write(0xF2 & BME280_MASK);
    spi.write(0x03);//Humidity oversampling ×4
    cs=1;
    
    //ctrl_meas
    cs=0;
    spi.write(0xF4 & BME280_MASK);
    spi.write((3<<5|3<<2)|3);//Temparature oversampling x4, Pressure oversampling x4, Normal mode
    cs=1;
    
    //config
    cs=0;
    spi.write(0xF5 & BME280_MASK);
    spi.write(0b10100000);
    cs=1;
    
    //設定おわり
    wait(1);
    
    //校正用データの処理
    //温度の校正値取得
    cs=0;
    spi.write(0x88);
    for(char i = 0;i<6;i++)
    {
        cmd[i]=spi.write(0);
    }
    cs=1;
    dig_T1=(cmd[1]<<8)|cmd[0];
    dig_T2=(cmd[3]<<8)|cmd[2];
    dig_T3=(cmd[5]<<8)|cmd[4];
    
    //圧力の校正値取得
    cs=0;
    spi.write(0x8E);
    for(char i = 0;i<18;i++)
    {
        cmd[i]=spi.write(0);   
    }
    cs=1;
    dig_P1=(cmd[1]<<8)|cmd[0];
    dig_P2=(cmd[3]<<8)|cmd[2];
    dig_P3=(cmd[5]<<8)|cmd[4];
    dig_P4=(cmd[7]<<8)|cmd[6];
    dig_P5=(cmd[9]<<8)|cmd[8];
    dig_P6=(cmd[11]<<8)|cmd[10];
    dig_P7=(cmd[13]<<8)|cmd[12];
    dig_P8=(cmd[15]<<8)|cmd[14];
    dig_P9=(cmd[17]<<8)|cmd[16];
    
    //湿度の校正値取得
    cs=0;
    spi.write(0xA1);
    cmd[0]=spi.write(0);
    cs=1;
    
    cs=0;
    spi.write(0xE1);
    for(char i = 0;i<7;i++)
    {
        cmd[1+i]=spi.write(0);
    }
    cs=1;
    dig_H1=cmd[0];
    dig_H2=(cmd[2]<<8)|cmd[1];
    dig_H3=cmd[3];
    dig_H4=(cmd[4]<<4)|(cmd[5]&0x0F);
    dig_H5=(cmd[6]<<4)|((cmd[5]>>4)&0x0F);
    dig_H6=cmd[7];
    
    //校正データ終わり
}    

    float BME280::getTemperature()
    {
        char cmd[18];
        DigitalOut cs(p8);
        SPI spi(p5,p6,p7);
        cs=1;
        spi.format(8, 0); // 8-bit, mode=0
        spi.frequency(1000000); // 1MHZ    
    
        cs=0;
        spi.write(0xFA);
        for(char i =0;i<3;i++)
        {
            cmd[i]=spi.write(0);
        }
        cs=1;
        uint32_t temp_raw;
        float tempf;
        temp_raw = (cmd[0] << 12) | (cmd[1] << 4) | (cmd[2] >> 4);

        int32_t temp;

    temp =
        (((((temp_raw >> 3) - (dig_T1 << 1))) * dig_T2) >> 11) +
        ((((((temp_raw >> 4) - dig_T1) * ((temp_raw >> 4) - dig_T1)) >> 12) * dig_T3) >> 14);

    t_fine = temp;
    temp = (temp * 5 + 128) >> 8;
    tempf = (float)temp;

    return (tempf/100.0f);
    }
    
    float BME280::getPressure()
    {
        int32_t cmd[18];
        DigitalOut cs(p8);
        SPI spi(p5,p6,p7);
        cs=1;
        spi.format(8, 0); // 8-bit, mode=0
        spi.frequency(1000000); // 1MHZ   
        cs=0;
        spi.write(0xF7);
        for(char i =0;i<3;i++)
        {
            cmd[i]=spi.write(0);
        }
        cs=1;
        
        //ここから
    uint32_t press_raw;
    float pressf;
    press_raw = (cmd[0] << 12) | (cmd[1] << 4) | (cmd[2] >> 4);

    int32_t var1, var2;
    uint32_t press;

    var1 = (t_fine >> 1) - 64000;
    var2 = (((var1 >> 2) * (var1 >> 2)) >> 11) * dig_P6;
    var2 = var2 + ((var1 * dig_P5) << 1);
    var2 = (var2 >> 2) + (dig_P4 << 16);
    var1 = (((dig_P3 * (((var1 >> 2)*(var1 >> 2)) >> 13)) >> 3) + ((dig_P2 * var1) >> 1)) >> 18;
    var1 = ((32768 + var1) * dig_P1) >> 15;
    if (var1 == 0) {
        return 0;
    }
    press = (((1048576 - press_raw) - (var2 >> 12))) * 3125;
    if(press < 0x80000000) {
        press = (press << 1) / var1;
    } else {
        press = (press / var1) * 2;
    }
    var1 = ((int32_t)dig_P9 * ((int32_t)(((press >> 3) * (press >> 3)) >> 13))) >> 12;
    var2 = (((int32_t)(press >> 2)) * (int32_t)dig_P8) >> 13;
    press = (press + ((var1 + var2 + dig_P7) >> 4));

    pressf = (float)press;
    return (pressf/100.0f);
    }
    
    float BME280::getHumidity()
    {
        char cmd[18];
        DigitalOut cs(p8);
        SPI spi(p5,p6,p7);
        cs=1;
        spi.format(8, 0); // 8-bit, mode=0
        spi.frequency(1000000); // 1MHZ   
        cs=0;
        spi.write(0xFD);
        for(char i = 0;i<2;i++)
        {
            cmd[i]=spi.write(0);   
        }
        cs=1;
    uint32_t hum_raw;
    float humf;
    hum_raw = (cmd[0] << 8) | cmd[1];

    int32_t v_x1;

    v_x1 = t_fine - 76800;
    v_x1 =  (((((hum_raw << 14) -(((int32_t)dig_H4) << 20) - (((int32_t)dig_H5) * v_x1)) +
               ((int32_t)16384)) >> 15) * (((((((v_x1 * (int32_t)dig_H6) >> 10) *
                                            (((v_x1 * ((int32_t)dig_H3)) >> 11) + 32768)) >> 10) + 2097152) *
                                            (int32_t)dig_H2 + 8192) >> 14));
    v_x1 = (v_x1 - (((((v_x1 >> 15) * (v_x1 >> 15)) >> 7) * (int32_t)dig_H1) >> 4));
    v_x1 = (v_x1 < 0 ? 0 : v_x1);
    v_x1 = (v_x1 > 419430400 ? 419430400 : v_x1);

    humf = (float)(v_x1 >> 12);

    return (humf/1024.0f);

    }