#include "mbed.h"

#ifndef InletClose_H
#define InletClose_H

class Inlet
{
private:
    DigitalOut _Out;//モータ用 1で回転,0で停止

    AnalogIn _In1;
    AnalogIn _In2;//感圧センサーとつなぐピン



public:

    float value1;//感圧センサーの値をいれる
    float value2;

    Inlet(PinName Out,PinName In1,PinName In2)
        :_Out(Out),_In1(In1),_In2(In2) {}


    void Close()
    {
        _Out=1;
    }

    void Stop()
    {
        _Out=0;
    }

    float getvalue1()
    {
        value1=_In1.read();
        return value1;
    }

    float getvalue2()
    {
        value2=_In2.read();
        return value2;
    }


};

#endif