#include "mbed.h"
#include "MU2.h"
#include "GPS.h"
#include "SDFileSystem.h"
#include "inletclose.h"
#include "mbedTimer.h"

#define WAITTIME 60       //フライトピン抜けてからの待機時間 60
#define FIRETIME 5       //溶断時間を設定 5
#define FALLTIME 420       //シェンロン展開してインレットを閉鎖するまでの時間を設定 420
#define THRESHOLID 0.45  //感圧のしきい値 0.45
#define SAMPLENUMBER 5   //しきい値判定に用いるサンプル数 5
#define CLOSETIME 60     //しきい値超えてからのインレット閉鎖機構の稼働時間を設定 60
#define LIMITTIME 1800   //しきい値超えなくてもインターバルモードへ移行
#define INTERVALTIME 7200 //インターバルモードの時間 1800
#define INTERVAL_HIGH 5  //インターバルモードでモーター回す時間 5
#define INTERVAL_LOW 20  //インターバルモードでモーター止める時間 20

char fname[]="/sd/CanSat/log0904EtoE2.csv";//ファイル名をここで設定
char fname2[]="/sd/CanSat/sensor0904EtoE2.csv";//感圧センサーのログファイル

////////////////フライトピンが抜ける→シェンロン展開→インレット閉鎖→待機
//シーケンス番号//1//////////////////2///////////3///////////4///
//mbedのLEDが各シーケンス番号を2進数で示す：ex 0011 インレット閉鎖中
//ただし今回はシーケンス4つなのでそれぞれのシーケンスでそれぞれのLEDが光る

MU2 MuPort(p28,p27);
SDFileSystem sd(p5, p6, p7, p8, "sd");//３号機11,12,13,14 ４号機5,6,7,8
GPS mygps(p13,p14);//３号機9,10　４号機13,14

Inlet inlet(p26,p15,p16);//モーター出力,感圧センサー1入力,感圧センサー2入力

DigitalOut FIRE(p25);    //３号機24　４号機25

DigitalOut myled(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

mbedTimer myTimer;
Timer timer_rec;//時間計測

int val;
int val2;
int val3;
int count;
char sendMessage[128];
char sensorMessage[128];
float ave_sensor;
int timer;
int timer2;
int timer3;
int timer4;

/*******************************************************************************
メイン関数
*******************************************************************************/

int main()
{

    timer_rec.start();
    wait(5);//起動してからちょっと待つ
    inlet.Stop();
    FILE* fp= fopen(fname, "a");
    if(fp == NULL) {

        myled=1;
        myled2=1;
        myled3=1;
        myled4=1;

        fp = fopen(fname, "a");
        if(fp != NULL) {
            myled=0;
            myled2=0;
            myled3=0;
            myled4=0;
        }

    }

    val=timer_rec.read();
    myTimer.sendMessage(val);
    fprintf(fp, "%s CanSatStart!\r\n",myTimer.timeMessage);
    MuPort.send(myTimer.timeMessage);
    MuPort.send("CanSat Start!\r\n");

    /*******************************************************************************
    溶断まで待機
    *******************************************************************************/
    timer=0;
    val2=0;
    val3=0;

    val=timer_rec.read();
    val3=val+val2;
    myTimer.sendMessage(val3);
    fprintf(fp, "%s GPSstart!\r\n",myTimer.timeMessage);
    MuPort.send(myTimer.timeMessage);
    MuPort.send("GPS start!\r\n");

    while(1) {
        myled=0;
        myled2=1;

        mygps.getGPGGA();
        if(mygps.GPSread) {
            myled=1;
            val=timer_rec.read();
            val3=val+val2;
            myTimer.sendMessage(val3);
            MuPort.send(myTimer.timeMessage);
            MuPort.send(mygps.getGPS);
            fprintf(fp, "%s %s\n",myTimer.timeMessage,mygps.getGPS);
            timer++;
        }

        if(timer>=WAITTIME) { //落下開始してからTBD秒後whileを抜ける．
            fclose(fp);
            break;
        }

        if(val>=1800) {
            //timer_rec.stop();
            timer_rec.reset();
            //timer_rec.start();
            val2+=val;
            val=0;

        }

    }


//溶断機構部分

    fprintf(fp, "FireStart!\r\n");
    MuPort.send("Fire Start!\r\n");

    FIRE=1;
    myled=1;
    wait(FIRETIME);//溶断にかかる時間TBD秒
    FIRE=0;
    myled=0;

    /*wait(3);

    FIRE=1;
    myled=1;
    wait(3);//溶断にかかる時間TBD秒
    FIRE=0;
    myled=0;*/

    fprintf(fp, "FireFinish!\r\n");
    MuPort.send("Fire Finish!\r\n");

//溶断機構終わり


    /*******************************************************************************
    シェンロン展開
    *******************************************************************************/
    timer=0;

    while(1) {
        myled=0;
        myled2=1;

        mygps.getGPGGA();
        if(mygps.GPSread) {
            myled=1;
            val=timer_rec.read();
            val3=val+val2;
            myTimer.sendMessage(val3);
            MuPort.send(myTimer.timeMessage);
            MuPort.send(mygps.getGPS);
            fprintf(fp, "%s %s\n",myTimer.timeMessage,mygps.getGPS);
            timer++;
        }

        if(timer>=FALLTIME) { //落下開始してからTBD秒後whileを抜ける．
            fclose(fp);
            break;
        }

        if(val>=1800) {
            //timer_rec.stop();
            timer_rec.reset();
            //timer_rec.start();
            val2+=val;
            val=0;

        }

    }


    /*******************************************************************************
    インレット連続閉鎖
    *******************************************************************************/

    fp= fopen(fname, "a");
    FILE* fp2= fopen(fname2, "a");
    val=timer_rec.read();
    val3=val+val2;
    myTimer.sendMessage(val3);
    fprintf(fp, "%s ClosingModeStart!\r\n",myTimer.timeMessage);
    MuPort.send(myTimer.timeMessage);
    MuPort.send("Closing Mode start!\r\n");

    timer=0;//モーター時間で止める用
    timer2=0;
    count=0;

    while(1) {
        myled=0;
        myled2=0;
        myled3=1;

        mygps.getGPGGA();

        val=timer_rec.read();
        val3=val+val2;
        myTimer.sendMessage(val3);
        inlet.getvalue1();
        inlet.getvalue2();
        ave_sensor=(inlet.value1+inlet.value2)/2;
        //fp2= fopen(fname2, "a");
        fprintf(fp2, "%s,%d,sensor1,%f,sensor2,%f,average,%f\n",myTimer.timeMessage,timer2,inlet.value1,inlet.value2,ave_sensor);
        //fclose(fp2);
        timer2++;

        if(mygps.GPSread) {
            myled2=1;
            val=timer_rec.read();
            val3=val+val2;
            myTimer.sendMessage(val3);
            MuPort.send(myTimer.timeMessage);
            MuPort.send(mygps.getGPS);
            snprintf(sensorMessage, 128, "%f", ave_sensor);
            MuPort.send(sensorMessage);
            fprintf(fp, "%s %s\n",myTimer.timeMessage,mygps.getGPS);
            timer++;
        }


        if(ave_sensor>THRESHOLID) {
            count++;
        }

        if(count>=SAMPLENUMBER) {
            val=timer_rec.read();
            val3=val+val2;
            myTimer.sendMessage(val3);
            fprintf(fp, "%s Get the rigidity!\r\n",myTimer.timeMessage);
            MuPort.send(myTimer.timeMessage);
            MuPort.send("Get the rigidity!\r\n");

            timer=0;//モーター時間で止める用

            while(1) {
                mygps.getGPGGA();

                val=timer_rec.read();
                val3=val+val2;
                myTimer.sendMessage(val3);
                inlet.getvalue1();
                inlet.getvalue2();
                ave_sensor=(inlet.value1+inlet.value2)/2;
                //fp2= fopen(fname2, "a");
                fprintf(fp2, "%s,%d,sensor1,%f,sensor2,%f,average,%f\n",myTimer.timeMessage,timer2,inlet.value1,inlet.value2,ave_sensor);
                //fclose(fp2);
                timer2++;

                if(mygps.GPSread) {
                    myled2=1;
                    val=timer_rec.read();
                    val3=val+val2;
                    myTimer.sendMessage(val3);
                    MuPort.send(myTimer.timeMessage);
                    MuPort.send(mygps.getGPS);
                    snprintf(sensorMessage, 128, "%f", ave_sensor);
                    MuPort.send(sensorMessage);
                    fprintf(fp, "%s %s\n",myTimer.timeMessage,mygps.getGPS);
                    timer++;
                }


                if(timer>=CLOSETIME) {
                    break;
                }

            }

            inlet.Stop();
            val=timer_rec.read();
            val3=val+val2;
            myTimer.sendMessage(val3);
            fprintf(fp, "%s ClosingModeFinish!\r\n",myTimer.timeMessage);
            MuPort.send(myTimer.timeMessage);
            MuPort.send("Closing Mode Finish!\r\n");
            fclose(fp);
            fclose(fp2);
            break;

        }
        

        if(val>=1800) {
            //timer_rec.stop();
            timer_rec.reset();
            //timer_rec.start();
            val2+=val;
            val=0;

        }
        
        if(timer>LIMITTIME) {
            inlet.Stop();
            val=timer_rec.read();
            val3=val+val2;
            myTimer.sendMessage(val3);
            fprintf(fp, "%s ClosingModeFinsh!\r\n",myTimer.timeMessage);
            MuPort.send(myTimer.timeMessage);
            MuPort.send("Closing Mode Finish!\r\n");
            fclose(fp);
            fclose(fp2);
            break;

        }

        inlet.Close(1.1);//1より大きい引数にしておけばモーターはずっと回ってる．

    }

    /*******************************************************************************
    インレットインターバル閉鎖
    *******************************************************************************/

    fp= fopen(fname, "a");
    fp2= fopen(fname2, "a");
    val=timer_rec.read();
    val3=val+val2;
    myTimer.sendMessage(val3);
    fprintf(fp, "%s IntervalModeStart!\r\n",myTimer.timeMessage);
    MuPort.send(myTimer.timeMessage);
    MuPort.send("Interval Mode start!\r\n");
    fclose(fp);

    timer=0;//モーター時間で止める用
    timer3=0;


    while(1) {

        myled=0;
        myled2=0;
        myled3=0;
        myled4=1;

        mygps.getGPGGA();

        val=timer_rec.read();
        val3=val+val2;
        myTimer.sendMessage(val3);
        inlet.getvalue1();
        inlet.getvalue2();
        ave_sensor=(inlet.value1+inlet.value2)/2;
        //fp2= fopen(fname2, "a");
        fprintf(fp2, "%s,%d,sensor1,%f,sensor2,%f,average,%f\n",myTimer.timeMessage,timer2,inlet.value1,inlet.value2,ave_sensor);
        //fclose(fp2);
        timer2++;

        if(mygps.GPSread) {
            myled3=1;
            val=timer_rec.read();
            val3=val+val2;
            myTimer.sendMessage(val3);
            MuPort.send(myTimer.timeMessage);
            MuPort.send(mygps.getGPS);
            snprintf(sensorMessage, 128, "%f\n", ave_sensor);
            MuPort.send(sensorMessage);
            fp= fopen(fname, "a");
            fprintf(fp, "%s %s\n",myTimer.timeMessage,mygps.getGPS);
            fclose(fp);
            fclose(fp2);
            fp2= fopen(fname2, "a");
            timer++;
            timer3++;
        }



        if(timer3>=INTERVAL_HIGH) {
            inlet.Stop();
            myled=0;
            myled2=0;
            myled3=0;
            myled4=1;

            timer3=0;
            timer4=0;

            while(1) {
                mygps.getGPGGA();

                val=timer_rec.read();
                val3=val+val2;
                myTimer.sendMessage(val3);
                inlet.getvalue1();
                inlet.getvalue2();
                ave_sensor=(inlet.value1+inlet.value2)/2;
                //fp2= fopen(fname2, "a");
                fprintf(fp2, "%s,%d,sensor1,%f,sensor2,%f,average,%f\n",myTimer.timeMessage,timer2,inlet.value1,inlet.value2,ave_sensor);
                //fclose(fp2);
                timer2++;

                if(mygps.GPSread) {
                    myled3=1;
                    val=timer_rec.read();
                    val3=val+val2;
                    myTimer.sendMessage(val3);
                    MuPort.send(myTimer.timeMessage);
                    MuPort.send(mygps.getGPS);
                    snprintf(sensorMessage, 128, "%f\n", ave_sensor);
                    MuPort.send(sensorMessage);
                    fp= fopen(fname, "a");
                    fprintf(fp, "%s %s\n",myTimer.timeMessage,mygps.getGPS);
                    fclose(fp);
                    fclose(fp2);
                    fp2= fopen(fname2, "a");
                    timer++;
                    timer4++;
                }


                if(timer4>=INTERVAL_LOW) {
                    break;
                }

            }

        }

        if(val>=1800) {
            //timer_rec.stop();
            timer_rec.reset();
            //timer_rec.start();
            val2+=val;
            val=0;

        }


        if(timer>=INTERVALTIME) {
            inlet.Stop();
            val=timer_rec.read();
            val3=val+val2;
            myTimer.sendMessage(val3);
            fprintf(fp, "%s IntervalModeFinish!\r\n",myTimer.timeMessage);
            MuPort.send(myTimer.timeMessage);
            MuPort.send("Interval Mode finish!\r\n");
            fclose(fp);
            fclose(fp2);
            break;
        }

        inlet.Close(1.1);//1より大きい引数にしておけばモーターはずっと回ってる．

    }


    /*******************************************************************************
    待機モード（何もせずGPS信号を発する）
    *******************************************************************************/

    fp= fopen(fname, "a");
    val=timer_rec.read();
    val3=val+val2;
    myTimer.sendMessage(val3);
    fprintf(fp, "%s StandbyModeStart!\r\n",myTimer.timeMessage);
    MuPort.send(myTimer.timeMessage);
    MuPort.send("Standby mode start!\r\n");
    fclose(fp);


    while(1) {
        myled=0;
        myled2=0;
        myled3=0;
        myled4=1;

        mygps.getGPGGA();
        if(mygps.GPSread) {
            myled3=1;
            val=timer_rec.read();
            val3=val+val2;
            myTimer.sendMessage(val3);
            MuPort.send(myTimer.timeMessage);
            MuPort.send(mygps.getGPS);
            fp= fopen(fname, "a");
            fprintf(fp, "%s %s\n",myTimer.timeMessage,mygps.getGPS);
            fclose(fp);
            //wait(1.0);
        }

        if(val>=1800) {
            //timer_rec.stop();
            timer_rec.reset();
            //timer_rec.start();
            val2+=val;
            val=0;
        }

    }

}


