#include "thermal.h"

#include "defines.h"


extern DigitalOut led2;
extern DigitalOut led3;
extern DigitalOut led4;



Thermal::Thermal(Terminal *t, I2C *i)
{
    term = t;
    //i2c = i;
    
    
     i2c = new I2C(p28, p27);
    
    i2c->frequency(100000);
    

}



int Thermal::D6T_getvalue() 
{ 
    //const char cmd[] = { 0x4C };
   char  I2C_rd[64];
   
   short  PTAT; 
   int  i,j;
   int  itemp;

    i2c->start();
    i2c->write(D6T_addr);
    i2c->write(D6T_cmd);
    // Repeated Start condition
    i2c->read(D6T_addr,I2C_rd,35);
    // if(check_PEC(I2C_rd) == -1) continue; // error
    for(i=0,j=0;i<17;i++)
    {
         itemp = (I2C_rd[j++] & 0xff);
         itemp += I2C_rd[j++] * 256;
         if(i == 0) PTAT = itemp;
         else temp[i-1] = itemp;
    }
    for(i=0;i<16;i++){
        dt[i] = 0.1 * temp[i];
    }
    d_PTAT = 0.1 * PTAT;
      
    tPEC = readbuff[34]; 
    return 1; 
} 




void Thermal::measure() 
{ 
    int n;
    int status;

    n = 0; 
    do{ 
        status = D6T_getvalue(); 
        n++; 
    } while(!status  && n < LOOPLIMIT); 
    
    if ( !status )
    { 
        // error operation. 
    } 
 
 
    l = 40.0;
    h = 0.0;
    m = 0.0;
 
    for (int x = 0; x < 16; x++ )
    {
        if ( dt[x] > h )
            h = dt[x]; 
        if ( dt[x] < l )
            l = dt[x];
        m += dt[x];     
     
        
    }        
 
    m /= 16;
 
    mean = m;
    low = l;
    high = h;
 
    
    char color[20];
    uint8_t detected;
 
    term->printf(" %2.1f, ", d_PTAT);

    detected = 0;
    for ( int x = 0; x < 16; x++ )
    {
        if ( dt[x] > mean + 0.5 )
        {
            strcpy(color, "\033[31m");
            detected = 1;
        }    
        else
            strcpy(color, "");
        term->printf("%s%2.1f\033[37m,", color, dt[x]);
    }
  
    term->printf(",%d" ,tPEC);
    term->printf(", %2.1f - %2.1f [%2.1f]\r\n", low, high, mean);
 
    if ( detected )
    {
        led2 = 1;
        led3 = 1;
        led4 = 1;    
    }
    else
    {
        led2 = 0;
        led3 = 0;
        led4 = 0;    
    }
            
 
 
    /*term->printf(" %d, %d,%d,%d,%d,%d,%d,%d,%d ,%d,%d,%d,%d,%d,%d,%d,%d ,%d\n" ,
                        tPTAT,tP[0],tP[1],tP[2],tP[3],tP[4],tP[5],tP[6],tP[7] 
                        ,tP[8],tP[9],tP[10],tP[11],tP[12],tP[13],tP[14],tP[15],tPEC);  */
            
}


uint8_t Thermal::calc_crc( uint8_t data ) 
{ 
    int index; 
    unsigned char temp; 
 
    for( index = 0; index < 8; index++ )
    { 
        temp = data; 
        data <<= 1; 
        if ( temp & 0x80 ) 
            data ^= 0x07; 
    } 
    return data; 
} 
 
int Thermal::D6T_checkPEC( uint8_t readbuff[] , int pPEC )
{ 
    uint8_t crc; 
    int i; 
 
    crc = calc_crc( 0x14 ); 
    crc = calc_crc( 0x4C ^ crc ); 
    crc = calc_crc( 0x15 ^ crc ); 
    for( i = 0; i < pPEC; i++ )
    { 
        crc = calc_crc( readbuff[i] ^ crc ); 
    } 
    return (crc == readbuff[pPEC]); 
} 
