/* 
* Anders Markland, Knightec AB
* 2013-11-15
*
*
*/

#include "mbed.h"

#include "Terminal.h"
#include "MODSERIAL.h"
#include "TextLCD.h"
#include "defines.h"
#include "mytimer.h"
//#include "presence.h"
//#include "thermal.h"



#define C_ae (0xE4)
#define C_aa (0xE5)
#define C_oe (0xF6)

#define C_AE (0xC4)
#define C_AA (0xC5)
#define C_OE (0xD6)


#define L_ae (0x84)
#define L_aa (0x94)
#define L_oe (0xF6)

#define L_AE (0x8E)
#define L_AA (0x8F)
#define l_OE (0x99)



Terminal *term; 
DigitalInOut reset(p9);
DigitalOut led1(LED1);  
DigitalOut led2(LED2);  
DigitalOut led3(LED3);  
DigitalOut led4(LED4);  

//Presence *presence;
//I2C i2c(p28, p27);
//I2C *i2c;


SPI spi_lcd(p5, NC, p7); // MOSI, MISO, SCLK
TextLCD lcd(&spi_lcd, p15, p8, TextLCD::LCD16x2); // SPI bus, CS pin, LCD Type ok

int presence = 0;

int seconds_since_movement = 0;
int last_inactive_period = 0;
int seconds_since_last_update = 0;

MODSERIAL radio(p9, p10); // tx, rx
//Serial uart(p13, p14);

int receiver = 0;

double  dt[16];
double  d_PTAT;


void pad(char *ptr, int l);

int D6T_getvalue();
int D6T_checkPEC( uint8_t buf[] , int pPEC ); 
void measure(); 
uint8_t calc_crc( uint8_t data );
char readbuff[35]; 
int tPTAT; 
int tP[16]; 
int tPEC; 
int time_since_ping;

uint8_t showoutput = 0;

 
 
// bool newline_detected = false;
 
// Called everytime a new character goes into
// the RX buffer. Test that character for \n
// Note, rxGetLastChar() gets the last char that
// we received but it does NOT remove it from
// the RX buffer.
/*void rxCallback(MODSERIAL_IRQ_INFO *q) {
    MODSERIAL *serial = q->serial;
    if ( serial->rxGetLastChar() == '\n') {
        newline_detected = true;
    }
}*/
  
 
 
Ticker flipper;
Ticker msflip;
Ticker sflip;

uint16_t msticks;
uint8_t print_tick;
 
void flip() 
{
    time_since_ping++;
    
    if ( receiver )
        if ( time_since_ping > 10 )
        {
            led2 = 1;
            led3 = 1;
            led4 = 1;
        }
        else 
        {
            led2 = 0;
            led3 = 0;
            led4 = 0;
        }
}
 
void ms()
{
    msticks++; 
} 
 
 
void s()
{
    seconds_since_last_update++; 
    print_tick++;
} 
 
 
enum StateType { Init, PresenceDetected, LastPresenceDetected, CommunicationFault } displayState;
 
 
 
 
/* 

------------------
" Scaniasatellit "
" bemannad       "
------------------ 

------------------
" Inaktivitet    "
" 00:03:22       "
------------------ 
  
------------------
" Fel:           "
" Kommunikation  "
------------------ 
*/

 
 
void showPresence(int s)
{
    time_t seconds = s;
    char str[32];
    char buf[30];


    struct tm *timeinfo;
    timeinfo  = localtime(&seconds);


    
    strftime(str, 32, "%T", localtime(&seconds));
    
    
    //lcd.cls();
    lcd.locate(0,0);
    
    char pr[10];
     
    if ( presence )
    {
        strcpy(pr, "Ja");
        sprintf(buf, " N%crvaro: %s", L_ae, pr);
        pad(buf, 16);
        lcd.printf("%s", buf);
    
        if ( s > 30 )
        {
            sprintf(buf, " %dd %s", timeinfo->tm_yday,  str);
        }
        else
        {
            strcpy(buf, " ");
        }
        pad(buf, 16);
        lcd.printf("%s", buf);
        
    }
    else
    {
        if ( s > 180 * 60 )         // No movement for 3 hours --> probably false trigger
            strcpy(pr, "Nej");
        else
            strcpy(pr, "?");    
        sprintf(buf, " N%crvaro: %s", L_ae, pr);
        pad(buf, 16);
        lcd.printf("%s", buf);
      
        
        sprintf(buf, " %dd %s", timeinfo->tm_yday,  str);
        pad(buf, 16);
        lcd.printf("%s", buf);
    }
}
 
void showAbsence(int s)
{
    time_t seconds = s;
    char str[32];

    strftime(str, 32, "%T", localtime(&seconds));
    
    lcd.cls();    
    //int inactiveTime;
    lcd.printf(" Inaktivitet   ");
    lcd.printf(" [%c] %s", presence?'X':' ', str);
}
 
void showError()
{
    lcd.cls();
    lcd.printf(" Fel:          ");
    lcd.printf(" Kommunikation "); 
} 


void pad(char *ptr, int l)
{
    int len = strlen (ptr);
    while ( len < l )
    {
        ptr[len++] = ' ';
        ptr[len] = '\0';
    }    
}

 
  
int main() 
{
    int last_elapsed_time = 0;
    
    displayState = Init;

    //set_time(0);  // Set RTC time to Wed, 28 Oct 2009 11:35:37
    
    receiver = 1;   //DEBUG
    
    term = new Terminal(USBTX, USBRX);
    //presence = new Presence(term);
   
    flipper.attach(&flip, 1.0);
    msflip.attach_us(&ms, 1000);
    sflip.attach(&s, 1);
 
    
    term->baud(115200);

    radio.baud(9600);
    //radio.attach(&rxCallback, MODSERIAL::RxIrq);

    //uart.baud(9600);

    term->cls();
    term->locate(0, 0);
    term->foreground(RED);
    term->printf("\n\rConnected to presence detector...\n\r");
    //term->printf("\nPress 'o' to activate output\n\n\r");

    term->foreground(WHITE);
    term->printf("Delay\r\n");
 
    //lcd.cls();
      

    lcd.printf("Hello"); 
 
    char buffer[32];
    time_t seconds = time(NULL);
  
  
    strftime(buffer, 32, "%F %T\n", localtime(&seconds));
    term->printf("Current time %s", buffer);    
     
    
    while (1) 
    {
        char ch;
        char buffer[50];
        int pos = 0;
        char rx;
        
        msticks = 0;
        /*while ( uart.readable() )
        {
           term->printf("%c", uart.getc());    
        } */
        
        if ( radio.readable() )
        {
            while ( msticks < 100 )
            {
                if ( radio.readable() )
                {
                    rx = radio.getc();
                    if ( rx == '!' )                    // Look for start of package
                    {
                        pos = 0;
                    }
                    //term->printf("%c", rx);
                    buffer[pos++] = rx;
                            
                    if ( rx == '\n' || pos > 40 )       // Prevent garbage from causing buffer overflow
                    {
                        buffer[pos] = '\0';
                        break;
                    }
                    //term->printf(",");
                }
            } 
        }
        
    
        if ( buffer[0] == '!' && (buffer[1] == 'M' || buffer[1] == 'P') && buffer[9] == '\n' ) //&& strlen(buffer) == 10 )
        {                                       // format: "!M00000pp\n"    Where "00000" are number of second since last movement and 'pp' is the ASCII hex coded xor parity byte
            uint8_t p = 0;
            char *ptr;
            int parity;
            char text[10];
            
            
            if ( buffer[1] == 'P' ) 
            {
                presence = 1;    
            }
            else
            {
                presence = 0;    
            }
            
            for ( uint8_t x = 0; x < 7; x++ )
            {
                p ^= buffer[x];  
            }
              
            ptr = buffer + 7;
            sscanf(ptr, "%x", &parity);
            
            //printf("%d %d\r\n", p, parity);
             
            if ( p == parity )
            {
                strncpy(text, buffer + 2, 5);
                text[5] = '\0';
                
                sscanf(text, "%d", &seconds_since_movement);
                seconds_since_last_update = 0;
                
                /*if ( seconds_since_movement < 10 )
                {
                    //printf("\xe2\x88\x9e\n");
                    if ( displayState != PresenceDetected )
                    {
                        displayState = PresenceDetected;
                        //printf("\r\nN%crvaro detekterad                 \r\n", C_ae);
                        //printf("%d\r\n", last_elapsed_time);
                    }
                }    
                else   
                {
                    displayState = LastPresenceDetected;
                   // printf("Seconds since last movement: %d    \r", seconds_since_movement);
                } */
            }    
        }
        /*else if ( !strcmp(buffer, "!P1\n") )
        {                                       // format: "!P1\n"    Confirmed presence
            seconds_since_last_update = 0;
            seconds_since_movement = 0;
        } */
           
        memset(buffer, '\0',10);                // Clear buffer until next packet is received
    
    //Presence, LastPresenceDetected, CommunicationFault } displayState;
    
        if ( print_tick )
        {
            time_t seconds = time(NULL);
            char str[32];
            strftime(str, 32, "[%F %T]", localtime(&seconds));
            
            
            showPresence(seconds_since_movement);
            
            if ( seconds_since_movement )
            {
                //showAbsence(seconds_since_movement);
                if ( displayState != LastPresenceDetected )
                {
                    term->printf("%s D%crr %cppnad/st%cngd\r\n", str, C_oe, C_oe, C_ae);
                    displayState = LastPresenceDetected;
                    //showAbsence();
                }
                if ( seconds_since_movement > last_inactive_period )
                {
                    last_inactive_period = seconds_since_movement;
                }
            }
            else
            {
//                showPresence(seconds_since_movement);
                
                if ( displayState != PresenceDetected )
                {
                    term->printf("Idle: %d\r\n", last_inactive_period);
                    term->printf("%s N%crvaro detekterad\r\n", str, C_ae);
                    
                    displayState = PresenceDetected;
                    last_inactive_period = 0;
                }
            }
            
            if ( seconds_since_movement < last_elapsed_time )
            {
                //printf("%s %d\r\n", str, last_elapsed_time);
            }
            
            //printf("%d %d\r\n", seconds_since_movement, last_elapsed_time);
            
            last_elapsed_time = seconds_since_movement;
            if ( seconds_since_last_update > 10 )
            {
                //if ( displayState != CommunicationFault )
                {
                    displayState = CommunicationFault;
                    term->printf("%s Kommunikationsfel %d\r\n", str, seconds_since_last_update);
                }
            }
            print_tick = 0;
        }        
        
        
        if ( term->readable())
        {
            ch = term->getc();
    
            switch(ch)
            {
case 'r':
                reset.output();
                break;            

case 't': 
                int y;
                int m;
                int d;
                int h;
                int mi;
                int s;
                char buf[100];
                char *ptr;
                term->printf("Enter new time: YYYY-MM-DD-HH-MM-SS\r\n");
                term->scanf("%s", buf); 
                sscanf(buf, "%4d-%2d-%2d-%2d-%2d-%2d", &y, &m, &d, &h, &mi, &s);
                
/*                term->printf("Entered string: %s\r\n", buf);
                term->printf("%4d-%2d-%2d %2d:%2d:%2d", y, m, d, h, mi, s); */
                             
                
              
                time_t rawtime;
                struct tm * timeinfo;
                //int year, month ,day;
                const char * weekday[] = { "Sunday", "Monday",
                                             "Tuesday", "Wednesday",
                                             "Thursday", "Friday", "Saturday"};
                
                /* get current timeinfo and modify it to the user's choice */
                time ( &rawtime );
                timeinfo = localtime ( &rawtime );
                timeinfo->tm_year = y - 1900;
                timeinfo->tm_mon = m - 1;
                timeinfo->tm_mday = d;
                  
                timeinfo->tm_hour = h;
                timeinfo->tm_min = mi; 
                timeinfo->tm_sec = s; 
                  
                
                /* call mktime: timeinfo->tm_wday will be set */
                set_time(mktime ( timeinfo ));


                time_t seconds = time(NULL);
                char str[32];
                strftime(str, 32, "[%F %T]", localtime(&seconds));
                term->printf("New time: %s\r\n", str);
                
                break;
case 'o':
                printf("Toggle output\r\n");
                showoutput = !showoutput;
                term->cls();
    
                break;
                
default:
                break;        
            }
        }    
        
//        led1 = !led1;
        
        if ( showoutput )
        {
            /*clear_screen++;
            if ( clear_screen > 50 )
            {
                term->cls();
                clear_screen = 0;
            }*/
            /*term->locate(0, 0);
            
            term->printf("Sensor output:\r\n");
            term->printf("--------------------------------------------------\r\n");            */         
            //presence->thermal->measure();
                        
            for ( int x = 0; x < 4; x++ )
            {
                for ( int y = 0; y  < 4; y++ )
                {
                    
/*                    term->foreground(RED); 
                    term->foreground(YELLOW); 
                    term->foreground(GREEN);                        
                    term->printf("%1.3fV    ", voltage);
                    term->foreground(WHITE);*/
                }
            //    term->printf("\r\n");
            }
        }
       
        //wait(0.2);        
    }
}




