#ifndef __thermal_h 
#define __thermal_h 

#include "mbed.h"
#include "Terminal.h"
 
#define LOOPLIMIT (10)
#define REPEATED_START (1)








class Thermal { 
 
public:
    Thermal(); 
    Thermal(Terminal *t, I2C *i); 
    
    int D6T_getvalue();
    int D6T_checkPEC( uint8_t buf[] , int pPEC ); 
    void measure(); 
    uint8_t calc_crc( uint8_t data );

    uint16_t temp[16]; 

private: 

    I2C *i2c;
    Terminal *term;
    
    uint8_t readbuff[35]; 
    int tPTAT; 
    int tP[16]; 
    int tPEC; 
    
    double  dt[16];
double  d_PTAT;

   
    float low;
    float high;
    float mean;
    
    float l;
    float h;
    float m;
    
    
    
};
 

#endif
