#if !defined(MQTTSOCKET_H)
#define MQTTSOCKET_H

#include "MQTTmbed.h"
#include "TCPSocket.h"

class MQTTSocket
{
public:

	MQTTSocket(): mysock(true)
	{

	}

    int open(NetworkStack *ipstack)
    {
    	_time_last_ticks = 0;
    	timesock.open(ipstack);
    	return mysock.open(ipstack);
    }

    int getNTPtime(int timeout=1000)
    {
    	int err;
    	int attempts = 0;

    	uint8_t timedata[4];

		timesock.set_timeout(timeout*3);
		do
		{
			err= timesock.connect("time-d.nist.gov", 37);

			if (err != 0)
			{
				LOG("ERROR resolving ntp server IP and connecting to it! \r\n");
				attempts++;
				if (attempts == 3)
					return err;
			}
		} while (err != 0);

		while (err != 4)
		{
			err = timesock.recv((char*)timedata, 4);

			if (err != 4)
			{
				LOG("ERROR receiving time from ntp server! \r\n");
				//return -1;
			}
			else
			{
				///
				/// Time Protocol provides the time as a binary number of seconds since 1900,
				///
				/// 2,208,988,800 corresponds to 00:00  1 Jan 1970 GMT from 12:00:01 am on 1 January 1900 GMT
				///
				_time_last_ticks = ((timedata[0]<<24 )|(timedata[1]<<16)|(timedata[2]<<8)| timedata[3]) - 2208988800ul;

				LOG("Success receiving time from ntp server. Tick from 1 Jan 1970 is equal to %d. \r\n", _time_last_ticks);

			}
		}

		err = timesock.close();

		return err;
    }

    int connect(char* hostname, int port, int timeout=1000)
    {
        int err;

        mysock.set_timeout(timeout);
        err = mysock.connect(hostname, port);  
//    t.start();             
        return err; 
    }

    int read(unsigned char* buffer, int len, int timeout)
    {
        mysock.set_timeout(timeout);        
//t.reset();
// int start = t.read_ms();
        int rc = mysock.recv((char*)buffer, len);
// int stop = t.read_ms();       
//        if (rc>0) printf ("recv File: %s, Line: %d Read nB: %d rc: %d timeout: %d elaps: %d\n\r",__FILE__,__LINE__, len, rc, timeout, stop-start);        
        return rc;
    }
    
    int write(unsigned char* buffer, int len, int timeout)
    {
        mysock.set_timeout(timeout);                
//        mysock.set_blocking(false, timeout);  
//        mysock.set_blocking(false);  
        int rc = mysock.send((char*)buffer, len);
//         printf ("send File: %s, Line: %d Write nB: %d rc: %d\n\r",__FILE__,__LINE__, len, rc);
        return rc;
    }
    
    int disconnect()
    {
//        t.stop();
        return mysock.close();
    }

    inline int getTime()
    {
    	return _time_last_ticks;
    }
     
private:
    TCPSocket mysock; 
    TCPSocket timesock;

    uint32_t _time_last_ticks;
 //   Timer t;
    
};
#endif
