#include "mbed.h"
#include "ID12RFID.h"
#include "NRF2401P.h"
#include "nRF24l01.h"

Serial infoout(PTA2,PTA1); //define the serial port, connected to the screen mbed

Serial weatherIn(PTE22,PTE23);


//DigitalOut myled(LED1);
char message[9]; //character array to store the data we send

int tagNumber; //stores the tagnumber read from the RFID reader

char c;
int i;



ID12RFID rfid(PTE1); //Initialise RFID reader and associated functions



int main() {
    
     long long addr1=0xAB01CD; // setup address - any 5 byte number - same as TX
     int channel =0x10;  // [0-126] setup channel, must be same as TX
     bool txOK;
     char msg[32];
     char ackData[32];
     char len;
     
     // Setup 
     NRF2401P nrf1(PTD2,PTD3, PTD1,PTD5,PTD0); //mosi, miso, sclk, csn, ce)
     nrf1.quickRxSetup(channel, addr1); // sets nrf24l01+ as  receiver, using pipe 1
     printf("Set up complete!\n\r");
     
     // set ack data
     sprintf(ackData,"Acknowledge data");
     printf("Ack data set.\n\r");
    
    while(1){
        
// receive
         while (! nrf1.isRxData()); // note this blocks until RX data
          
         len= nrf1.getRxData(msg); // gets the message, len is length of msg
         msg[len] = 0;
         printf("%s",msg);
         nrf1.acknowledgeData(ackData, strlen(ackData),1); // ack for pipe 1
         
        for(int n =0; n<sizeof(msg) ; n++){
            //send the data to the second mbed(screen) using putc
            infoout.putc(msg[n]);
            //,waiting 0.05 seconds after each character
            wait(0.05);
            }
//        
        int i=0;
/*
        if(rfid.readable()){
               //if we can read a tag, get the tagnumber
               tagNumber = rfid.read();
              sprintf(message,"a%d",tagNumber); //turn the tagnumber into a string, string starts with a to identify string as an RFID tagnumber
              
               
            
            for(int n =0; n<9 ; n++){
            //send the data to the second mbed(screen) using putc
            infoout.putc(message[i]);
            i=(i+1)%9; //modulo 9 to ensure only 9 characters are sent
            
            //,waiting 0.05 seconds after each character
            wait(0.05);
            }
            
            if(i==0){
            infoout.putc('A'); //end the message with 'A' to denote the end of an RFID
            
            wait(0.01);
            }
        }
               
        
        if(weatherIn.readable()){
       
                c=weatherIn.getc();
                infoout.putc(message[i]);
                message[i] = c;
                i=(i+1)%9;
                
                wait(0.05);
        }             
            

            
            
       */ 
    }
        
                 
}

