#include "mbed.h"
#include "LCDTFT.h"

BusOut MyBus(PTA13,PTD5,PTD4,PTA12,PTA4,PTA5,PTC8,PTC9);     // 8 bit bus on these dvices
LCDTFT     MyLCD(PTB0,PTB1,PTB2,PTB3,PTC2,&MyBus);           //LCDTFT(PinName PIN_RD,PinName PIN_WR,PinName PIN_RS,PinName PIN_CS,PinName PIN_RESET, BusOut *BUSLCD);

DigitalOut myled(LED1);                         // define status LED
Serial infoin(PTE0,PTE1);                       // define serial 
Serial pc(USBTX,USBRX);                         // for use with pc terminal
DigitalOut unlock(PTB8);                        // flag pin to output to locker
DigitalIn doorOpen(PTB9);                       // flag pin for input from locker

int Rawl = 22319109; //define two integers to associate the tagnumbers with people
int Fish = 22312052;
int tagNumber;

char c;
int i;

//define required flags and initialize floats for te weather data.

float temperature = 45;
float light = 100;
float pressure;
float humidity;
char message[20];


int main() {
     unlock =1;                                                     // send a high level to the locker
     MyLCD.vLCDTFTInit(1);                                          // sets LCD to landscape mode
     MyLCD.vLCDTFTFillScreen(Cyan);
     
     MyLCD.vLCDTFTLine(0,120,320,120,Black);                        // separates weather data from RFID info
     
     MyLCD.vLCDTFTSetParametersPrintf(5,130,0,320,2,Black,Cyan);    // display labels for all time FOREVER
     MyLCD.printf("Temperature:");
         
     MyLCD.vLCDTFTSetParametersPrintf(5,160,0,320,2,Black,Cyan);
     MyLCD.printf("Humidity:");
     
     MyLCD.vLCDTFTSetParametersPrintf(5,190,0,320,2,Black,Cyan);
     MyLCD.printf("Light:");
     
     MyLCD.vLCDTFTSetParametersPrintf(5,220,0,320,2,Black,Cyan);
     MyLCD.printf("Pressure:");
     
     
     
     
    
    while(1) {
       
            if(doorOpen == 1){                              // prints to terminal when door is open - for use later
                pc.printf("Door is Open");
            }
       
            if(infoin.readable()) {                             // if serial bus has data, read it character by character
            c=infoin.getc();
            message[i] = c;                                 // store in character array 'message'
            i++;
            
                if(c=='a'){                                                     //if the first letter is a, we're getting an RFID                                               
                    i=0;
                }  
            
                if(c=='A'){                                                     //if we get 'A', we reach the end of the RFID
                    MyLCD.vLCDTFTSetParametersPrintf(5,5,0,320,3,Fuchsia,Cyan);
                    MyLCD.printf("Welcome, ");
                    sscanf(message,"%d",&tagNumber);                            // save tagNumber as integer
                    if(tagNumber == Fish) MyLCD.printf("Lew");                  // match tagNumber to Name
                    if(tagNumber == Rawl) MyLCD.printf("Tom");
                
                    i=0;
                
                    unlock = 0;                     // send pulse to locker
                    wait(0.2);
                    unlock = 1;
                }
            
                                                
                      
            //Here begin the if statements for weather data
            
                if ( c == 'l') {                // start of light data
                    i = 0;                  
                }
                
                if ( c == 'L') {              // end of light data
                 
                    MyLCD.vLCDTFTSetParametersPrintf(5,190,0,320,2,Black,Cyan);
                 
                    sscanf(message,"%f",&light);                                    // convert string to float
                    MyLCD.printf("Light: %5.2f",light);
                 
                    MyLCD.vLCDTFTRectangle(260,190,315,200,1,Cyan);                // needed to clear the visuals
                 
                    if(light>0) MyLCD.vLCDTFTCircle(265,195,5,1,Yellow);      // if statements for number of suns

                    if(light>25) MyLCD.vLCDTFTCircle(280,195,5,1,Yellow);

                    if(light>50) MyLCD.vLCDTFTCircle(295,195,5,1,Yellow);

                    if(light>75) MyLCD.vLCDTFTCircle(310,195,5,1,Yellow);

                 
                    i=0;
                    wait(1);
                }
                
                if ( c == 't') {      // start of temperature data
                    i = 0;                  
                }
                              
                if ( c == 'T') {      // end of temperature data
                 
                    MyLCD.vLCDTFTSetParametersPrintf(5,130,0,320,2,Black,Cyan);

                    sscanf(message,"%f",&temperature);                             // convert string to float
                    MyLCD.printf("Temperature: %5.2f",temperature);           
                 
                    MyLCD.vLCDTFTRectangle(260,130,315,140,1,Cyan);                // needed to clear visuals
                                  
                    if(temperature>0) MyLCD.vLCDTFTRectangle(260,130,270,140,1,Lime);     // if statements for temperature bar

                    if(temperature>10) MyLCD.vLCDTFTRectangle(275,130,285,140,1,Yellow);

                    if(temperature>20) MyLCD.vLCDTFTRectangle(290,130,300,140,1,Orange);

                    if(temperature>30) MyLCD.vLCDTFTRectangle(305,130,315,140,1,Red);
                
                    i=0;
                    wait(1);                                  
                }              
              
                if ( c == 'p') {      // start of pressure data
                    i = 0;                  
                }
              
                if ( c == 'P') {      // end of pressure data
                 
                    MyLCD.vLCDTFTSetParametersPrintf(5,220,0,320,2,Black,Cyan);
                                
                    sscanf(message,"%f",&pressure);                             // convert string to float
                    MyLCD.printf("Pressure: %5.2f",pressure);  
                 
                                        
                    i=0;
                    wait(1);              
                }              
                
                if ( c == 'h') {      // start of humidity data
                    i = 0;                  
                }  
                            
                if ( c == 'H') {      // end of humidity data
                 
                    MyLCD.vLCDTFTSetParametersPrintf(5,160,0,320,2,Black,Cyan);              
                                                 
                    sscanf(message,"%f",&humidity);                             // convert string to float
                    MyLCD.printf("Humidity: %5.2f",humidity);  
                 
                    //MyLCD.printf("\n\r");
                    i=0;
                    wait(1);  
                }    
    
            }
    
    }
}
