 #include "mbed.h"
 #include "ms5637.h"
 #include "DHT.h"
 #include "NRF2401P.h"
#include "nRF24l01.h"
 
ms5637 ms(PTC9,PTC8);                        // i2c pins used
Serial pc(USBTX, USBRX);                   // local terminal interface
AnalogIn ldr(PTB3);
DHT sensor(PTE5,SEN11301P);
Serial myarduino(PTE0, PTE1);

 int main (void) {
     //pc.baud(921600);                        // set up USB serial speed

     // set up the ms5637
     pc.printf("\n\nInitializing the MS5637..\n");
     ms.cmd_reset();
     pc.printf("Ready\n");
     
    float Vo;
//    float R = 10000; // 10k
//    float Vin = 3.3; // input from 3V3
    
    int err;
    printf("\r\n Test program");
    printf("\r\n******************\r\n");
    
//NRF    
     long long addr1=0xAB01CD; // setup address - any 5 byte number - same as RX
     int channel =0x10;  // [0-126] setup channel, must be same as RX
     bool txOK;
     char msg[32];
     char ackData[32];
     char len;
 
     // Setup 
     NRF2401P nrf1(PTD2,PTD3, PTD1,PTD5, PTD0); //mosi, miso, sclk, csn, ce)
     nrf1.quickTxSetup(channel, addr1); // sets nrf24l01+ as transmitter
     printf("set up complete \n\r");
//
     
    //initialise data to be sent
    char bufferL[50];
    char bufferT[50];
    char bufferP[50];
    char bufferH[50];
    
    int nL;
    int nT;
    int nP;
    int nH;
 
    myarduino.baud(9600);
    
    wait(1); // wait 1 second for device stable status

      while(1) {
          // Humidity and temperature DHT11 sensor
           err = sensor.readData();           
        if (err == 0) {
            printf("\n\r\n\rHumidity is %4.2f \r\n",sensor.ReadHumidity());
            printf("Temperature is %4.2f C \r\n",sensor.ReadTemperature(CELCIUS));
        } else { 
            while ( err != 0 ) {
               err = sensor.readData();           
            }
            printf("\n\r\n\rHumidity is %4.2f \r\n",sensor.ReadHumidity());
            printf("Temperature is %4.2f C \r\n",sensor.ReadTemperature(CELCIUS));
        }
      
          // Temperature and pressure sensor ms
          double Temp2 = ms.calcTemp();                         //calculate press and temp, then returns current temperature in degC
          double Press = ms.calcPressure();                    //calculate press and temp, then returns current pressure in mb
          double GetPress = ms.getPressure();                  //returns current pressure in mb. Does no calculations.  Ususally done after calcTemp()
 
          pc.printf("Temp: %.2f degC\n\r", Temp2);    
          pc.printf("Barometer: %.1f mB  %.3f in/Hg\n\r", Press, Press * 0.0295301);

        // Light Sensor LDR
        Vo = ldr.read();
//        float Rt = (Vo*R)/(Vin - Vo);
//        float FTC = (powf(10,5.57644))*(powf(Rt,-1.211743));
//        float Lux = FTC*10.76;
// FAULTY:float pd = (-3.4099 *10000000)*(Vo)*Vo + (3.1612e5)*(Vo) - 266.5672; 
          float pd = 1.7833/Vo;
          printf("Sensor reading (Vo): %f V\r\n", Vo);
          printf("Sensor reading (power density): %f W/m^2\r\n\r\n", pd);        
        
//        printf("FTC: %f\r\n",FTC);
//        printf("Lux: %f\r\n\r\n",Lux);       
        
        wait(2);
        
        
//Light        
         sprintf(msg, "l%0.3fL\n\r",pd); 
         txOK= nrf1.transmitData(msg,strlen(msg));
         printf("L sent \n\r");
         
         // read ack data if available
         if (nrf1.isAckData()) { 
             len= nrf1.getRxData(ackData); // len is number of bytes in ackData
             ackData[len]=0;
             printf("%s\n\r\n\r",ackData);              
          }
//Temperature           
          sprintf(msg, "t%0.3fT\n\r",Temp2); 
         txOK= nrf1.transmitData(msg,strlen(msg));
         printf("T sent \n\r");
         
         // read ack data if available
         if (nrf1.isAckData()) { 
             len= nrf1.getRxData(ackData); // len is number of bytes in ackData
             ackData[len]=0;
             printf("%s\n\r\n\r",ackData);              
          } 
//Pressure           
           sprintf(msg, "p%0.3fP\n\r",Press); 
         txOK= nrf1.transmitData(msg,strlen(msg));
         printf("P sent \n\r");
         
         // read ack data if available
         if (nrf1.isAckData()) { 
             len= nrf1.getRxData(ackData); // len is number of bytes in ackData
             ackData[len]=0;
             printf("%s\n\r\n\r",ackData);              
          }
//Humidity           
        sprintf(msg, "h%0.3fH\n\r",sensor.ReadHumidity()); 
         txOK= nrf1.transmitData(msg,strlen(msg));
         printf("H sent \n\r\n\r");
         
         // read ack data if available
         if (nrf1.isAckData()) { 
             len= nrf1.getRxData(ackData); // len is number of bytes in ackData
             ackData[len]=0;
             printf("%s\n\r\n\r",ackData);              
          }        
      }
  }
