#include "mbed.h"
#include "NRF2401P.h"
#include "nRF24l01.h"

int main(){
       
 long long addr1=0xAB01CD; // setup address - any 5 byte number - same as TX
 int channel =0x10;  // [0-126] setup channel, must be same as TX
 bool txOK;
 char msg[32];
 char ackData[32];
 char len;
 
 // Setup 
 NRF2401P nrf1(PTD2,PTD3, PTD1,PTD5,PTD0); //mosi, miso, sclk, csn, ce)
 nrf1.quickRxSetup(channel, addr1); // sets nrf24l01+ as  receiver, using pipe 1
 
 printf("Set up complete!\n\r");
 
 // set ack data
 sprintf(ackData,"Acknowledge data");

printf("Ack data set.\n\r");

    while (1) {
         // receive
         while (! nrf1.isRxData()); // note this blocks until RX data
          
         len= nrf1.getRxData(msg); // gets the message, len is length of msg
         msg[len] = 0;
         printf("%s",msg);
         nrf1.acknowledgeData(ackData, strlen(ackData),1); // ack for pipe 1
    }
}