#include "mbed.h"
#include "TCS3472_I2C.h"
#include "Motor.h"

PwmOut LB(p22); // PWM out signal to power LED on the sensor
TCS3472_I2C rgb_sensor( p9, p10 ); // Establish RGB sensor object

Motor m(p26, p30, p29);
Motor m2(p25, p27, p28);
AnalogIn ultraSonic(p17);
int bob=0;

int main()
{
    rgb_sensor.enablePowerAndRGBC(); // Enable RGB sensor
    rgb_sensor.setIntegrationTime(100); // Set integration time of sensor

    float measurements = ultraSonic.read();
    float meas_dist = 531.3726*measurements + 0.8440;


    int rgb_data[4]; // declare a 3 element array to store RGB sensor readings
    float PWMbrightness = 1.0; // declare a float specifying brightness of LED (between 0.0 and 1.0)
    LB = PWMbrightness; // set brightness of sensor LED
    wait(1);
    while(meas_dist > 20) {


        rgb_sensor.getAllColors( rgb_data ); // read the sensor to get red, green, and blue color data along with overall brightness

        // Print data to serial port
        m2.speed(0);
        m.speed(.6);
        while ((rgb_data[2] >= 300)) {//Right If Green color is greater than 200 (the color is green)
            m2.speed(.6);
            m.speed(0);
            rgb_sensor.getAllColors( rgb_data );

            measurements = ultraSonic.read();
            meas_dist = 531.3726*measurements + 0.8440;
            if (meas_dist <10)
            {
                //int bob=1;
                break;};
        };
        while ((rgb_data[1] <= 225)) {//if red color is less than 180 (the color is blue)
            m2.speed(0);
            m.speed(0.5);
            rgb_sensor.getAllColors( rgb_data );

            measurements = ultraSonic.read();
            meas_dist = 531.3726*measurements + 0.8440;
             if (meas_dist <10)
            {
                //int bob=1;
                break;};
        };
        while ((rgb_data[3] <= 180)) {//Left If the blue is less than 95 (the color is red)
            m2.speed(-.6);
            m.speed(0);
            rgb_sensor.getAllColors( rgb_data );

            measurements = ultraSonic.read();
            meas_dist = 531.3726*measurements + 0.8440;
             if (meas_dist <10)
            {
                //int bob=1;
                break;
            };
        };
       
    };
    m.speed(0);
    m2.speed(0);
    wait(.75);
        
}