/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "stats_report.h"
#include "MS5607SPI.h"

DigitalOut led1(LED1);

//MS5xxx sensor(&wire);

// main() runs in its own thread in the OS
int main()
{
    MS5607SPI ms5607(D11, D12, D13, D10);
    
    SystemReport sys_state(500 /* Loop delay time in ms */);
    
    while (true) 
    {
        ms5607.printCoefficients();
        printf("Pressure = %.0f Pa\n", ms5607.getPressure());
        printf("Temperature = %.2f degC\n", ms5607.getTemperature());
        printf("Altitude = %.2f m\n", ms5607.getAltitude());
        
        // Blink LED and wait 0.5 seconds
        led1 = !led1;
        wait(0.5f);

        // Following the main thread wait, report on the current system status
        sys_state.report_state();
    }
}
