/* Includes */

#include "mbed.h"
#include "x_nucleo_iks01a1.h"
#include  "lsm6ds0_class.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

//Serial pc(PC_4, PC_5); //TX, RX UART !!!!!!!!
Serial pc(SERIAL_TX, SERIAL_RX); //PC


/* Instantiate the expansion board */
static X_NUCLEO_IKS01A1 *mems_expansion_board = X_NUCLEO_IKS01A1::Instance(D14, D15);

static HumiditySensor *humidity_sensor = mems_expansion_board->ht_sensor;
static PressureSensor *pressure_sensor = mems_expansion_board->pt_sensor;
static TempSensor *temp_sensor1 = mems_expansion_board->ht_sensor;
static TempSensor *temp_sensor2 = mems_expansion_board->pt_sensor;


void From_Pressure_mb_To_Altitude_US_Std_Atmosphere_1976_ft(float* Pressure_mb, float* Altitude_ft);
void From_Temp_and_pressure_to_altitude_in_feer(float* Pressure_mb, float* temp_in_fahrenheit, float* Altitude_ft);
void From_ft_To_m(float* ft, float* m);
void altitude_from_press_and_presscurrent(float* Pressure_mb,float* Altitude_m);

/* Helper function for printing floats & doubles */
static char *printDouble(char* str, double v, int decimalDigits=2)
{
    int i = 1;
    int intPart, fractPart;
    int len;
    char *ptr;

    /* prepare decimal digits multiplicator */
    for (; decimalDigits!=0; i*=10, decimalDigits--);

    /* calculate integer & fractinal parts */
    intPart = (int)v;
    fractPart = (int)((v-(double)(int)v)*i);

    /* fill in integer part */
    sprintf(str, "%i.", intPart);

    /* prepare fill in of fractional part */
    len = strlen(str);
    ptr = &str[len];

    /* fill in leading fractional zeros */
    for (i/=10; i>1; i/=10, ptr++) {
        if(fractPart >= i) break;
        *ptr = '0';
    }

    /* fill in (rest of) fractional part */
    sprintf(ptr, "%i", fractPart);

    return str;
}



/* Simple main function */
int main()
{
    uint8_t id;
    float value1, value2;
    char buffer1[32], buffer2[32];
    float Altitude_ft,Altitude_m;
    float m;


    pc.printf("\r\n--- Starting new run ---\r\n");

    humidity_sensor->ReadID(&id);
    pc.printf("HTS221  humidity & temperature    = 0x%X\r\n", id);
    pressure_sensor->ReadID(&id);
    pc.printf("LPS25H  pressure & temperature    = 0x%X\r\n", id);

    wait(3);

    while(1) {
        printf("\r\n");

        temp_sensor1->GetTemperature(&value1);
        humidity_sensor->GetHumidity(&value2);
        pc.printf("HTS221: [temp] %7s°C,   [hum] %s%%\r\n", printDouble(buffer1, value1), printDouble(buffer2, value2));

        temp_sensor2->GetFahrenheit(&value1);
        pressure_sensor->GetPressure(&value2);
        pc.printf("LPS25H: [temp] %7s°F, [press] %smbar\r\n", printDouble(buffer1, value1), printDouble(buffer2, value2));
       
        From_Pressure_mb_To_Altitude_US_Std_Atmosphere_1976_ft(&value2,&Altitude_ft);
        From_ft_To_m(&Altitude_ft,&m);
        pc.printf("LPS25H: [altitude] %7sfeet, [altitude] %smetres\r\n",printDouble(buffer1, Altitude_ft), printDouble(buffer2, m) );
        temp_sensor1->GetTemperature(&value1);
        From_Temp_and_pressure_to_altitude_in_feer(&value2, &value1, &Altitude_ft);
        From_ft_To_m(&Altitude_ft,&m);
        pc.printf("LPS25H: [altitude] %7sfeet, [altitude] %smetres\r\n",printDouble(buffer1, Altitude_ft), printDouble(buffer2, m) );
        altitude_from_press_and_presscurrent(&value2,&Altitude_m);
        pc.printf("LPS25H: [altitude] %smetres\r\n",printDouble(buffer2, Altitude_m) );
        pc.printf("---\r\n");

        wait(2);
    }
}
void altitude_from_press_and_presscurrent(float* Pressure_mb,float* Altitude_m){
    
    *Altitude_m=44330*(1-pow(*Pressure_mb/1013.25,1/5.255));
      
    }

void From_Temp_and_pressure_to_altitude_in_feer(float* Pressure_mb, float* temp_in_celsius, float* Altitude_ft)
{
    float tempf=*temp_in_celsius;
    float PA=*Pressure_mb;
    *Altitude_ft=1.24*PA + 118.8*tempf-1782;
    
}

void From_Pressure_mb_To_Altitude_US_Std_Atmosphere_1976_ft(float*
        Pressure_mb, float* Altitude_ft)
{
//=(1-(Pressure/1013.25)^0.190284)*145366.45
    *Altitude_ft = (1-pow(*Pressure_mb/1013.25,0.190284))*145366.45;
}

void From_ft_To_m(float* ft, float* m)
{
    //=feet/3.280839895
    *m = *ft/3.280839895;
}
