#include "mbed.h"

DigitalOut led1(LED1);

InterruptIn sensor1(D12);
InterruptIn sensor2(D11);

Serial pc(USBTX, USBRX); // tx, rx

Timer Timer1;
Timer Timer2;
Timer Timer3;

int count = 0;
double T1 = 0;
double T2 = 0;
double Snelheid = 0;
double Afstand = 0;

void sensor1rise()
{
    Timer1.start();
}

void sensor1fall()
{    
    count++;
    
    Timer2.stop();
    T2 = Timer2.read_us();
    Timer2.reset();
    
    // Lengte berekenen
    Afstand = 85 + (Snelheid * (T2 * 0.000001));
    
    if (count == 13)
    {   
        //pc.printf("T1                   : %d \r\n",(int)T1);
        //pc.printf("Snelheid in m/s    : %.5f \r\n",Snelheid);
        pc.printf("%.5f \r\n",Afstand);
        //c.printf("\r\n");
        count = 1;
    }
}

void sensor2rise()
{
    Timer2.start();
    
    Timer1.stop();
    T1 = Timer1.read_us();
    Timer1.reset();
    
    
    //Snelheid berekenen.
    Snelheid = 0.075 / (T1 * 0.000001);     //0.24
    
}

void sensor2fall()
{

}

int main()
{
    sensor1.mode(PullDown);
    sensor2.mode(PullDown);
    sensor1.rise(callback(sensor1rise));
    sensor1.fall(callback(sensor1fall));
    sensor2.rise(callback(sensor2rise));
    sensor2.fall(callback(sensor2fall));   
    
    pc.printf("Meetsysteem start\n");
    
    while(1) 
    {
        led1 = sensor1;
        
        wait(0.2);    
    }
}