#include"Adafruit_PWMServoDriver.h"

Adafruit_PWMServoDriver pwm(PA_10, PA_9, 0x82);
 
void setServoPulse(uint8_t n, float pulse) {
    float pulselength = 10000;   // 10,000 units per seconds
    pulse = 4094 * pulse / pulselength;
    pwm.setPWM(n, 0, pulse);
}
 
void initServoDriver() {
   pwm.begin();
   pwm.i2c_probe();
    pwm.setPrescale(64);    //This value is decided for 10ms interval.
    pwm.setI2Cfreq(400000); //400kHz
}
 
 int main() {

    while(1){
    initServoDriver();
    wait(0.2);
    setServoPulse(0, 2300);
    setServoPulse(1, 500);    
    wait(0.5);//delay necessary to perform the action
    setServoPulse(0, 1350);
    setServoPulse(1, 1350);
    wait(0.5);
    setServoPulse(0,550);
    setServoPulse(1, 2250);
    wait(0.5);
    setServoPulse(0, 2300);
    wait(2);
    for (int mov = 550; mov < 2300; mov++){
    setServoPulse(0, mov);
    wait(0.001); 
    }  
    for (int mov = 500; mov < 2200; mov++){
    setServoPulse(1, mov);
    wait(0.001); 
    }     
   }
}