#include "JoystickPS3.h"
#include "Motor.h"
#include "mbed.h"
/* Inisialisasi  Pin TX-RX Joystik dan PC */
joysticknucleo joystick(PA_0,PA_1);
Serial pc(USBTX,USBRX);
/* Deklarasi Motor Base */
Motor motorDepan(PB_8, PC_6, PC_5); //(PB_9, PA_12, PC_5); 
Motor motorBelakang(PB_9, PA_12, PA_6);
//Motor motorKiri  (PB_9, PA_6, PA_12);

/****************************************************/
/*         Deklarasi Fungsi dan Procedure           */
/****************************************************/
int case_joystick()
{
//---------------------------------------------------//
//  Gerak Motor Base                                 //
//   Case 1  : Pivot kanan                           //
//   Case 2  : Pivot Kiri                            //
//   Case 3  : Maju                                  //
//   Case 4  : Kiri                                  //
//   Case 5  : Bawah                                 //
//   Case 6  : Kanan                                 //
//---------------------------------------------------//
    
    int caseJoystick;
    if ((joystick.R1)&&(!joystick.L1)&&(!joystick.atas)&&(!joystick.bawah)&&(!joystick.kanan)&&(!joystick.kiri))  {  
        // Pivot Kanan
        caseJoystick = 1;
    } 
    else if ((!joystick.R1)&&(joystick.L1)&&(!joystick.atas)&&(!joystick.bawah)&&(!joystick.kanan)&&(!joystick.kiri))  {  
        // Pivot Kiri
        caseJoystick = 2;
    }
    else if ((!joystick.R1)&&(!joystick.L1)&&(joystick.atas)&&(!joystick.bawah)&&(!joystick.kanan)&&(!joystick.kiri))  {  
        // Pivot Kiri
        caseJoystick = 3;
    }
    else if ((!joystick.R1)&&(!joystick.L1)&&(!joystick.atas)&&(!joystick.bawah)&&(!joystick.kanan)&&(joystick.kiri))  {  
        // Pivot 
        caseJoystick = 4;
    }
    else if ((!joystick.R1)&&(!joystick.L1)&&(!joystick.atas)&&(!joystick.bawah)&&(!joystick.kanan)&&(!joystick.kiri))  {  
        // Pivot Kiri
        caseJoystick = 5;
    }
    else if ((!joystick.R1)&&(!joystick.L1)&&(!joystick.atas)&&(!joystick.bawah)&&(joystick.kanan)&&(!joystick.kiri))  {  
        // Pivot Kiri
        caseJoystick = 6;
    }
    return(caseJoystick);
}

void aktuator(int case_joy)
{
    switch (case_joy) {
        case (1): 
        {       
            // Pivot Kanan
			motorDepan.speed(0.2);
			motorBelakang.speed(-0.2);
            break;
        }
        case (2): 
        {
            // Pivot Kiri
			motorDepan.speed(-0.2);
			motorBelakang.speed(0.2);
            break;
        }
        case (3): 
        {
            // Maju
			motorDepan.speed(0.2);
			motorBelakang.speed(0.2);
            break;
        }
        case (4): 
        {
            // Mundur
			motorDepan.speed(-0.2);
			motorBelakang.speed(-0.2);
            break;
        }
		default : 
        {
            break;
        }
	}
}  
/*********************************************************/
/*                  Main Function                        */
/*********************************************************/

int main (void)
{
    // Set baud rate - 115200
    joystick.setup();
    pc.baud(115200);
    wait_ms(1000);
    int case_joy;
//    startMillis();
    while(1)
    {   
        // Interrupt Serial
        joystick.idle();        
        if(joystick.readable()) 
        {
            // Panggil fungsi pembacaan joystik
            joystick.baca_data();
            // Panggil fungsi pengolahan data joystik
            joystick.olah_data();
            // Masuk ke case joystick
            case_joy = case_joystick();
            //pc.printf("%d\n",case_joy);
            aktuator(case_joy);
        }
        else
        {
			joystick.idle();
        }
        
//        if(millis() - previousMillis5 >= 400)
//        {    
//            display.write(0,((int) rpm2) / 10);
//            display.write(1,((int)rpm2) % 10);
//            display.write(2, (int)target_rpm2 / 10);
//            display.write(3, (int)target_rpm2 % 10);
//            display.setColon(true);
//            
//            previousMillis5 = millis();
//        }
		
    }
	
}