/*Garudago ITB 2019 Attributes*/

#ifndef ROBOTPIN_H
#define ROBOTPIN_H

#include "mbed.h"
#include "encoderKRAI.h"
#include "CMPS12_KRAI.h"
#include "Motor.h"
#include "encoderHAL.h"
#include <garudago_hardware_interface/JoystickPS3.h>


//Serial pin for UART Arduino
#define PIN_TX              PA_0
#define PIN_RX              PA_1

//Serial Initiate
// Serial pc(USBTX, USBRX, 115200);
joysticknucleo stick(PIN_TX, PIN_RX);

//Compass
CMPS12_KRAI compass_sensor(PC_9,PA_8, 0xC0);

//Internal Encoder From Motor using interrupt
encoderKRAI enc_right_top(PC_12, PC_11, 537.6, encoderKRAI::X4_ENCODING);
encoderKRAI enc_left_top(PC_3,  PC_2,  537.6, encoderKRAI::X4_ENCODING);
encoderKRAI enc_left_back(PC_15, PC_14, 537.6, encoderKRAI::X4_ENCODING);
encoderKRAI enc_right_back(PC_13, PC_10, 537.6, encoderKRAI::X4_ENCODING);
encoderKRAI enc_shagai(PC_6, PC_7, 538, encoderKRAI::X4_ENCODING);

//input capture encoder
// encoderHAL enc2(TIM4);
// encoderHAL enc3(TIM2);
// encoderHAL enc1(TIM3);

Motor motor_right_top(PA_7,PA_5,  PA_6);
Motor motor_left_top(PB_0,PC_1, PC_0);
Motor motor_left_back(PB_1,PB_14, PB_15);
Motor motor_right_back(PA_11,PA_12,PB_12);
Motor motor_shagai(PA_15, PA_13, PA_14 );

//pneu[0]   opto 7   = pneu buat ambil shagai           1->Pengambil tertutup
//pneu[1]   opto 8   = pneu untuk extention             1->Ekstension memanjang
//pneu[2]   opto 9   = pneu untuk pelontar              1->Pelontar tidak memanjang
//pneu[3]   opto 2   = pneu untuk pencapit gerege       1->Pencapit tertutup
//pneu[4]   opto 5   = pneu untuk menaikkan gerege      1->Posisi naik
DigitalOut pneu[5] = {(PC_8),(PA_9),(PC_5),(PB_3),(PB_10)};

#endif