/*Garudago ITB 2019 Attributes*/

#ifndef  CONFIG_H
#define CONFIG_H

const float  PI = 3.141592;
const float  RAD_TO_DEG = 57.295779;
const float  WHEEL_RAD = 0.075;

const float  motor_distance_from_center = 0.365;
const float  encoder_distance_from_center = 0.139;
const float  position_tolerance = 0.05;
const float  orientation_tolerance = 0.05;

const float  max_velocity_magnitude = 2.0;
const float  max_rotation_magnitude = 3.0;
const float  cutoff_velocity_magnitude = 0.4;
const float  cutoff_rotation_magnitude = 1.6;

const float  max_linear_acceleration_magnitude = 2.5;
const float  max_angular_acceleration_magnitude = 4.0;
const float  max_linear_deceleration_magnitude = 1.9;
const float  max_angular_deceleration_magnitude = 4.0;

const float  linear_acceleration_feedforward_factor = 1.0;
const float  angular_acceleration_feedforward_factor = 1.0;
const float  linear_deceleration_feedforward_factor = 1.0;
const float  angular_deceleration_feedforward_factor = 1.0;

const float right_top_kp = 0.05;
const float right_top_ki = 0.49;
const float right_top_kd = 0.0;
const float right_top_N  = 0.0;
const float right_top_TS = 0.02;
const float right_top_FF = 0.0;

const float left_top_kp = right_top_kp;
const float left_top_ki = right_top_ki;
const float left_top_kd = 0.0;
const float left_top_N  = 0.0;
const float left_top_TS = 0.02;
const float left_top_FF = 0.0;

const float right_back_kp = right_top_kp;
const float right_back_ki = right_top_ki;
const float right_back_kd = 0.0;
const float right_back_N  = 0.0;
const float right_back_TS = 0.02;
const float right_back_FF = 0.0;

const float left_back_kp = right_top_kp;
const float left_back_ki = right_top_ki;
const float left_back_kd = 0.0;
const float left_back_N  = 0.0;
const float left_back_TS = 0.02;
const float left_back_FF = 0.0;

const float manual_linear_velocity = 6;

#endif