#include "mbed.h"
#include "Motor.h"
#include "encoderKRAI.h"
#include <stdio.h>

Serial pc(USBTX, USBRX, 115200)

//PinList
Motor motorA(PB_7,PC_3,PC_0);
EncoderKRAI encoderA(PB_1,PB_2,538,encoderKRAI::X4_ENCODING);// input pin

//Define
double pulse, total_pulse,velA;
float pwm;
typedef int IdxType;
typedef int ElType;
typedef struct{
    ElType TI[IdxMax];
    int Neff;
}TabInt;
TabInt A,B,C;
IdxType i;
const float  wheel_radius                           = 0.050;
const float  PI                                     = 3.141592;
float sample_time                                   = 10;

void locomotionMovement();

//Procedures Implementation
int main(){
    startMillis();
    //gerak motor
    while (1){
        if (millis()- last_timer >= sample_time){
            //read actual velocity (feedback)
            velA   = (encoderA.getPulses()  * 2 * PI * wheel_radius)/(0.003*538);
            //give pwm to motor
            while (pwm<=0.8){
                pwm=pwm+0.1
            }    
            motorA.speed(pwm);
            //reset encoder
            encoderA.reset();
            last_timer = millis();
            pc.printf("%d\n", velA));
    }
}     

}    