#include "mbed.h"
#include "encoderKRAI.h"
#include "Motor.h"
#include "millis.h"
 
encoderKRAI encLauncherDpn( PC_10, PC_11, 28, encoderKRAI::X4_ENCODING);
encoderKRAI encLauncherBlk( PC_12, PD_2, 28, encoderKRAI::X4_ENCODING);
Serial pc(USBTX,USBRX);

Motor launcherDpn(PA_5,PA_11,PB_12); 
Motor launcherBlk(PB_3, PC_4, PA_10);

unsigned long int previousMillis = 0;
unsigned long int currentMillis;
int rpm;



int main() {

startMillis();  
pc.baud(115200);  
//launcherDpn.speed(0.8);
launcherBlk.speed(0.8);
startMillis();
    
    while(1) {

        currentMillis = millis();
        
        
        if (currentMillis-previousMillis>=12.5)
        {
            //rpm = encLauncherDpn.getPulses();
            rpm = encLauncherBlk.getPulses();
            pc.printf("%d\n",rpm);
            //encLauncherDpn.reset();
            encLauncherBlk.reset();
            previousMillis = currentMillis;
        }

    }
}
