#include "Motor.h"
#include "mbed.h"

DigitalIn limitAtasLifter(PB_3, PullUp);  // Vertikal Atas: Lifter
DigitalIn limitAtasSaucer(PB_2, PullUp);  // Vertikal Atas: Saucer
DigitalIn limitBawah(PB_10, PullUp); // Vertikal Bawah
DigitalIn limitKiri(PA_5, PullUp);  // Horizontal Kiri
DigitalIn limitTengah(PC_9, PullUp);// Horizontal Tengah
DigitalIn limitKanan(PC_8, PullUp); // Horizontal Kanan (Frisbee keluar)

Motor powerScrew(PA_8, PC_1, PC_2); // pwm, fwd, rev
Motor pulley(PA_10, PC_3, PC_0); 

int state = 0;
int up = 0;

int main()
{
    float pwmPower  = -1.0;
    while(1) {
            /* limit switch atas */
            if ((!limitAtasLifter) && (up)){
                if(state == 0){
                    state = 1;
                }
                up = 0;
                pwmPower = -1.0;
            }
            
            /* limit switch bawah */
            if (!limitBawah){
                if(state == 0){
                    state = 1;
                }
                else if ((state == 1)||(up == 0)){
                    state = 0;
                }
                
                up = 1;
                pwmPower = 1.0;
            }
            
            /* limit switch saucer */
            if ((!limitAtasSaucer) && (up)){
                state = 0;
                pwmPower = 1.0;
            }
            /*
            else if ((limitAtasSaucer) && (up))
            {
                state = 1;
                pwmPower = 1.0;
            }
            */
            
            /* motor */
            if (state == 1){
                powerScrew.speed(pwmPower);
            }
            else if (state == 0){
                powerScrew.brake(1);
            }
    }
}