#ifndef OMNIPOS_H
#define OMNIPOS_H

#include "mbed.h"
#include "encoderKRAI.h"

#define diameterRoda 10

// Deklarasi variabel encoder
// Lebih jelas baca file encoderKRAI.h
encoderKRAI encoderDepan( D2, D3, 2000, encoderKRAI::X2_ENCODING);   //inA, inB, pin Indeks (NC = tak ada), resolusi, pembacaan
encoderKRAI encoderBelakang( D4, D5, 2000, encoderKRAI::X2_ENCODING);
encoderKRAI encoderKanan( D6, D7, 2000, encoderKRAI::X2_ENCODING);
encoderKRAI encoderKiri( D8, D9, 2000, encoderKRAI::X2_ENCODING);

class omniPos {
public:

    /** Dkiri untuk Motor 1
     *  Dkanan untuk Motor 2        
     *  Bkanan untuk Motor 3        
     *  Bkiri untuk Motor 4
     *      _________________
     *      |     DEPAN     |
     *      | 1.         .2 |
     *      | `           ` |
     *      | .           . |
     *      | 4`         `3 |
     *      |_______________|
     *      
     */
    typedef enum Wheel {

        Dkiri,
        Dkanan,
        Bkanan,
        Bkiri

    } Wheel;
    
    // Membuat interface dari omniPos
    omniPos(Wheel wheel);
    
    // Set center/pusat posisi omni.
    // Posisi sekarang saat di reset akan dijadikan pusat (0,0)
    void setCenter(void);
    
    // Membaca posisi X-axis dari satu omni wheel
    float getX(void);
    
    // Membaca posisi Y-axis dari satu omni wheel
    float getY(void);
    
    // Membaca tetha atau sudut rotasi robot
    float getTetha(void);
    
    // Membaca posisi 1 omni wheel ==> fi (rad)
    float getPos();
    
    // Membaca kecepatan angular 1 omni wheel  ==> fi dot (rad/s)
    float getVel(int delta_t);
};

#endif