// Library
#include "mbed.h"
#include "Motor.h"

// Deklarasi pin
Motor motor1 (PB_9, PA_12, PC_5);
Motor motor2 (PA_11, PA_6, PC_6);

int main (void){
    Serial pc(USBTX,USBRX);
    pc.baud(9600);
    pc.readable();
    float pwm1=0.1;
    float pwm2=0.1;
    
    while(1){
        char val = pc.getc();
        switch (val) {
            case 'a' :{
                pwm1 = pwm1+0.05;
            }
            break; 
            case 's' :{
                pwm1 = pwm1-0.05;
            }
            break;
            case 'k' :{
                pwm2 = pwm2+0.05;
            }
            break;
            case 'l' :{
                pwm2 = pwm2-0.05;
            }
            break;
        }
        if (pwm1 <= 0.1){ 
            pwm1 = 0.1;
        }
        if (pwm2 <= 0.1){ 
            pwm2 = 0.1; 
        }
        
        motor1.speed(pwm1);
        motor2.speed(pwm2);
        wait_ms(5);
        pc.printf ("pwm1 = %.5f      pwm2 = %.5f\n", pwm1, pwm2);
    }
}