#include "mbed.h"
#include "JoystickPS3.h"
#include "Motor.h"
#include "encoderKRAI.h"
#include "millis.h"

#define PI 3.14159265
#define D_ENCODER 10        // Diameter Roda Encoder
#define D_ROBOT1 54         // Diameter Roda Robot dari kiri ke kanan
#define D_ROBOT2 79         // Diameter Roda Robot dari depan ke belakang

bool auto_rotate=false, flag_start=true, flag_buttonL1, flag_buttonR1, flag_select;
bool reset_encoder = true;

int mode=0;

float V_x = 0.4, V_y = 0.3, V_pivot = 0.2;
float rasio= (D_ROBOT2/D_ROBOT1);

float K_enc = PI*D_ENCODER;
float K_robot1 = PI*D_ROBOT1;
float K_robot2 = PI*D_ROBOT2;

float PIDSpeedX, PIDSpeedY, PIDSpeedT;
float speedDpn, speedBlk, speedR, speedL;
const float maxPIDSpeed = 0.3, minPIDSpeed = -0.3, Ts = 50;
const float maxPIDSpeedT = 0.4, minPIDSpeedT = -0.4;
double current_error, previous_error1 = 0, previous_error2 = 0;
unsigned long int previousMillis=0;
float setpointX=0.0, setpointY=0.0, setpointT=0.0;

/* Untuk PID */
float errorX, previous_errorX=0, derivativeX, integralX=0;
float errorY, previous_errorY=0, derivativeY, integralY=0;
float errorT, previous_errorT=0, derivativeT, integralT=0;
float KpX=0.11, KiX=0, KdX=0;
float KpY=0.11, KiY=0, KdY=0;
float KpT=0.08, KiT=0, KdT=3.33;

/* Untuk joystick */
int case_joy;

/* Inisialisasi  Pin TX-RX Joystik dan PC */
joysticknucleo joystick(PA_0,PA_1);
Serial pc(USBTX,USBRX);

/* Deklarasi Encoder Base */
encoderKRAI encKanan( PA_14, PA_15, 28, encoderKRAI::X4_ENCODING);
encoderKRAI encBlk( PB_4, PB_5, 28, encoderKRAI::X4_ENCODING);
encoderKRAI encDpn( PC_11, PC_10, 28, encoderKRAI::X4_ENCODING);
encoderKRAI encKiri( PC_12, PD_2, 28, encoderKRAI::X4_ENCODING);

/* Deklarasi Motor Base */
Motor motorDpn(PB_7, PC_3, PC_0);
Motor motorBlk(PB_2, PB_15, PB_1);
Motor motorL  (PB_9, PA_12, PA_6);  
Motor motorR  (PB_8, PC_6, PC_5);

void setCenter()
{
/* Fungsi untuk menentukan center dari robot */
    encDpn.reset();
    encBlk.reset();
    encKiri.reset();
    encKanan.reset();
}

int case_joystick()
{    
    int caseJoystick;
    if ((joystick.R1)&&(!joystick.L1)&&(!joystick.atas)&&(!joystick.bawah)&&(!joystick.kanan)&&(!joystick.kiri))  {  
        // Pivot Kanan
        caseJoystick = 1;
    } 
    else if ((!joystick.R1)&&(joystick.L1)&&(!joystick.atas)&&(!joystick.bawah)&&(!joystick.kanan)&&(!joystick.kiri))  {  
        // Pivot Kiri
        caseJoystick = 2;
    }
    else if ((joystick.R1)&&(!joystick.L1)&&(!joystick.atas)&&(!joystick.bawah)&&(joystick.kanan)&&(!joystick.kiri))  {  
        // Kanan + Rotasi kanan
        caseJoystick = 3;
    } 
    else if ((!joystick.R1)&&(joystick.L1)&&(!joystick.atas)&&(!joystick.bawah)&&(joystick.kanan)&&(!joystick.kiri))  {  
        // Kanan + Rotasi kiri
        caseJoystick = 4;
    }
    else if ((joystick.R1)&&(!joystick.L1)&&(!joystick.atas)&&(!joystick.bawah)&&(!joystick.kanan)&&(joystick.kiri))  {  
        // Kiri + Rotasi kanan
        caseJoystick = 5;
    } 
    else if ((!joystick.R1)&&(joystick.L1)&&(!joystick.atas)&&(!joystick.bawah)&&(!joystick.kanan)&&(joystick.kiri))  {  
        // Kiri + Rotasi kiri
        caseJoystick = 6;
    }
    else if ((joystick.R1)&&(!joystick.L1)&&(joystick.atas)&&(!joystick.bawah)&&(!joystick.kanan)&&(!joystick.kiri))  {  
        // Maju + Rotasi kanan
        caseJoystick = 7;
    } 
    else if ((!joystick.R1)&&(joystick.L1)&&(joystick.atas)&&(!joystick.bawah)&&(!joystick.kanan)&&(!joystick.kiri))  {  
        // Maju + Rotasi kiri
        caseJoystick = 8;
    }
    else if ((joystick.R1)&&(!joystick.L1)&&(!joystick.atas)&&(joystick.bawah)&&(!joystick.kanan)&&(!joystick.kiri))  {  
        // Mundur + Rotasi kanan
        caseJoystick = 9;
    } 
    else if ((!joystick.R1)&&(joystick.L1)&&(!joystick.atas)&&(joystick.bawah)&&(!joystick.kanan)&&(!joystick.kiri))  {  
        // Mundur + Rotasi kiri
        caseJoystick = 10;
    }
    else if ((!joystick.R1)&&(!joystick.L1)&&(!joystick.atas)&&(!joystick.bawah)&&(joystick.kanan)&&(!joystick.kiri))  {  
        // Kanan
        caseJoystick = 11;
    }
    else if ((!joystick.R1)&&(!joystick.L1)&&(!joystick.atas)&&(!joystick.bawah)&&(!joystick.kanan)&&(joystick.kiri))  {  
        // Kiri
        caseJoystick = 12;
    }
    else if ((!joystick.R1)&&(!joystick.L1)&&(joystick.atas)&&(!joystick.bawah)&&(!joystick.kanan)&&(!joystick.kiri))  {  
        // Maju
        caseJoystick = 13;
    }
    else if ((!joystick.R1)&&(!joystick.L1)&&(!joystick.atas)&&(joystick.bawah)&&(!joystick.kanan)&&(!joystick.kiri))  {  
        // Mundur
        caseJoystick = 14;
    }
    
    return(caseJoystick);
}

void aktuator()
{
    switch (case_joy) {
        case (1):        
            // Pivot Kanan
            motorDpn.speed(-V_pivot/rasio);
            motorBlk.speed(-V_pivot/rasio);
            motorR.speed(-V_pivot);
            motorL.speed(-V_pivot);
            break;
        case (2): 
            // Pivot Kiri
            motorDpn.speed(V_pivot/rasio);
            motorBlk.speed(V_pivot/rasio);
            motorR.speed(V_pivot);
            motorL.speed(V_pivot);
            break;
        case (11): 
            // Kanan
            /*speedDpn = -(V_x + PIDSpeedT);
            speedBlk = (V_x + PIDSpeedT);
            speedR   = rasio*PIDSpeedT + PIDSpeedY;
            speedL   = rasio*PIDSpeedT - PIDSpeedY;*/
            speedDpn = -(V_x);
            speedBlk = (V_x);
            //speedR   = PIDSpeedY;
            //speedL   = - PIDSpeedY;
            motorDpn.speed(speedDpn);
            motorBlk.speed(speedBlk);
            motorR.brake(1);
            motorL.brake(1);
            break;
        case (12): 
            // Kiri
            /*speedDpn = (V_x + PIDSpeedT);
            speedBlk = -(V_x + PIDSpeedT);
            speedR   = rasio*PIDSpeedT + PIDSpeedY;
            speedL   = rasio*PIDSpeedT - PIDSpeedY;*/
            speedDpn = (V_x);
            speedBlk = -(V_x);
            //speedR   = PIDSpeedY;
            //speedL   = -PIDSpeedY;
            motorDpn.speed(speedDpn);
            motorBlk.speed(speedBlk);
            motorR.brake(1);
            motorL.brake(1);
            break;
        case (13): 
            // Maju
            motorDpn.brake(1);
            motorBlk.brake(1);
            motorR.speed(0.3);
            motorL.speed(-0.3);
            break;
        case (14): 
            // Mundur
            motorDpn.brake(1);
            motorBlk.brake(1);
            motorR.speed(-0.3);
            motorL.speed(0.3);
            break;
        default : 
            motorDpn.brake(1);
            motorBlk.brake(1);
            motorR.brake(1);
            motorL.brake(1);
            break;
    } // End Switch
}

float getX()
{
    float  jarakEncDpn, jarakEncBlk;
    jarakEncDpn = (encDpn.getPulses())/(float)(540.0)*K_enc;
    jarakEncBlk = (encBlk.getPulses())/(float)(540.0)*K_enc;
    return (jarakEncBlk-jarakEncDpn)/2;   
}

float getY()
{
    float  jarakEncKir, jarakEncKan;
    jarakEncKir = (encKiri.getPulses())/(float)(540.0)*K_enc;
    jarakEncKan = (encKanan.getPulses())/(float)(540.0)*K_enc;
    return (jarakEncKan-jarakEncKir)/2;   
}

float getTetha()
{
    float busurDpn, busurBlk, busurKir, busurKan, sudut;
    busurKir = ((encKiri.getPulses())/(float)(540.0)*K_enc)/K_robot2*360.0;
    busurKan = ((encKanan.getPulses())/(float)(540.0)*K_enc)/K_robot2*360.0;
    busurDpn = ((encDpn.getPulses())/(float)(540.0)*K_enc)/K_robot1*360.0;
    busurBlk = ((encBlk.getPulses())/(float)(540.0)*K_enc)/K_robot1*360.0;
    sudut = (busurDpn+busurBlk+busurKir+busurKan)/4;
    if (sudut>=360.0 || sudut<=-360.0)
    {
        sudut = 0.0;   
    }
    return sudut;    
}

void PIDcompute()
{   
    errorX = setpointX - getX();
    errorY = setpointY - getY();
    errorT = setpointT - getTetha();
    
    integralX = integralX + errorX*Ts;
    integralY = integralY + errorY*Ts;
    integralT = integralT + errorT*Ts;
    
    derivativeX = (errorX - previous_errorX)/Ts;
    derivativeY = (errorY - previous_errorY)/Ts;
    derivativeT = (errorT - previous_errorT)/Ts;
    
    PIDSpeedX = KpX*errorY + KiX*integralY + KdX*derivativeX;
    PIDSpeedY = KpY*errorY + KiY*integralY + KdY*derivativeY;
    PIDSpeedT = KpT*errorT + KiT*integralT + KdT*derivativeT;
    
    previous_errorX = errorX;
    previous_errorY = errorY;
    previous_errorT = errorT;
    
    if(PIDSpeedX > maxPIDSpeed){
        PIDSpeedX = maxPIDSpeed;
    }
    else if (PIDSpeedX < minPIDSpeed){
        PIDSpeedX = minPIDSpeed;
    }
    
    if(PIDSpeedY > maxPIDSpeed){
        PIDSpeedY = maxPIDSpeed;
    }
    else if (PIDSpeedY < minPIDSpeed){
        PIDSpeedY = minPIDSpeed;
    }
    
    if(PIDSpeedT > maxPIDSpeedT){
        PIDSpeedT = maxPIDSpeedT;
    }
    else if (PIDSpeedT < minPIDSpeedT){
        PIDSpeedT = minPIDSpeedT;
    }
}

void aturSetpoint()
{
    switch (mode) 
    {
        case (-2):        
            setpointT = -45.0;
            break;
        case (-1): 
            setpointT = -20.0;
            break;
        case (0):        
            setpointT = 0.0;
            break;
        case (1): 
            setpointT = 20.0;
            break;
        case (2): 
            setpointT = 45.0;
            break;
    }
}
void cekMode()
{
    if (mode<-2){mode = -2;}
    else if (mode>2){mode = 2;}   
}

void case_autoRotate()
{
    if ((joystick.R1_click)&&(!joystick.L1_click)&&flag_buttonR1)  
    {  
        flag_buttonR1 = false;
        mode--;
        cekMode();
        pc.printf("masuk R1, mode = %d\n",mode);
    }
    else { flag_buttonR1 = true; } 
    
    if ((!joystick.R1_click)&&(joystick.L1_click)&&flag_buttonL1)
    {  
        flag_buttonL1 = false;
        mode++;
        cekMode();
        pc.printf("masuk L1, mode = %d\n",mode);
    }
    else { flag_buttonL1 = true; }
    
    if ((joystick.START_click)&&(!joystick.SELECT_click)&&flag_start)
    {   
        // Masuk auto rotate
        flag_start = false;
        auto_rotate = true;
        flag_buttonR1 = true;
        flag_buttonL1 = true;
        flag_select = true;
        pc.printf("MASUK AUTO ROTATE");     
    }
    else { flag_start = true; }
    
    if ((!joystick.START_click)&&(joystick.SELECT_click)&&flag_select)
    {   
        // Keluar auto rotate
        flag_select = false;
        auto_rotate = false;
        reset_encoder = true;
        setpointT = 0.0;
        mode = 0; 
        pc.printf("KELUAR AUTO ROTATE");      
    }
    else { flag_select = true; }
}

int main(void)
{
    joystick.setup();
    pc.baud(115200);
    wait_ms(1000);
    startMillis();
    while(1)
    {   
        
        //COBA ROTASI
        joystick.idle();        
        if(joystick.readable()) 
        {
            // Panggil fungsi pembacaan joystik
            joystick.baca_data();
            // Panggil fungsi pengolahan data joystik
            joystick.olah_data();
            // Masuk ke case joystick
            case_joy = case_joystick();
            aktuator();
            
            case_autoRotate();

            while(auto_rotate)
            {
                joystick.idle();        
                if(joystick.readable()) 
                {                    
                    joystick.baca_data();
                    joystick.olah_data();
                    
                    if (reset_encoder){ setCenter(); reset_encoder = false; }
                    
                    case_autoRotate();
                    aturSetpoint();
                    
                    while (millis()-previousMillis>=Ts)
                    { PIDcompute(); previousMillis = millis(); }
                    
                    //speedDpn = PIDSpeedT/rasio - PIDSpeedX;
                    //speedBlk = PIDSpeedT/rasio + PIDSpeedX;
                    //speedR   = PIDSpeedT + PIDSpeedY;
                    //speedL   = PIDSpeedT - PIDSpeedY;
                    
                    speedDpn = PIDSpeedT;
                    speedBlk = PIDSpeedT;
                    speedR   = PIDSpeedT*rasio;
                    speedL   = PIDSpeedT*rasio;
                    
                    if ((errorT > 0.5) || (errorT<-0.5))
                    {
                        motorDpn.speed(speedDpn);
                        motorBlk.speed(speedBlk);
                        motorR.speed(speedR);
                        motorL.speed(speedL);    
                    }
                    else
                    {
                        motorDpn.brake(1);
                        motorBlk.brake(1);
                        motorR.brake(1);
                        motorL.brake(1);    
                    }
                    pc.printf("SUDUT = %f\n",getTetha());
                    case_autoRotate();
                }
                else
                {
                    joystick.idle();
                }
            }
        }
        else
        {
            joystick.idle();
        }
    }
}