#include "mbed.h"
#include "TextLCD.h"
#define chatter 100

TextLCD lcd(P0_22, P0_11, P0_10, P0_7, P0_9, P0_8); // rs, e, d4-d7
DigitalIn button_short(P0_12,PullUp);
DigitalIn button_long(P0_14,PullUp);
DigitalIn button_enter(P0_13,PullUp);
int button_short_count;
int button_long_count;
int button_enter_count;
int input;
int input_log;
char morse[16];
int cursor;
int input_cursor;

void init()
{
    button_short_count=0;
    button_long_count=0;
    input=0;
    input_log=0;
    morse[16];
    cursor=0;
    input_cursor=0;
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("ニ\n");
    while(!(button_short && button_long && button_enter)){
    }
}

char morse_code(int morse){
    char moji;
    if (morse==0){moji=' ';
    }else if (morse==13){moji='A';
    }else if (morse==3111){moji='B';
    }else if (morse==3131){moji='C';
    }else if (morse==311){moji='D';
    }else if (morse==1){moji='E';
    }else if (morse==1131){moji='F';
    }else if (morse==331){moji='G';
    }else if (morse==1111){moji='H';
    }else if (morse==11){moji='I';
    }else if (morse==1333){moji='J';
    }else if (morse==313){moji='K';
    }else if (morse==1311){moji='L';
    }else if (morse==33){moji='M';
    }else if (morse==31){moji='N';
    }else if (morse==333){moji='O';
    }else if (morse==1331){moji='P';
    }else if (morse==3313){moji='Q';
    }else if (morse==131){moji='R';
    }else if (morse==111){moji='S';
    }else if (morse==3){moji='T';
    }else if (morse==113){moji='U';
    }else if (morse==1113){moji='V';
    }else if (morse==133){moji='W';
    }else if (morse==3113){moji='X';
    }else if (morse==3133){moji='Y';
    }else if (morse==3311){moji='Z';
    }else if (morse==13333){moji='1';
    }else if (morse==11333){moji='2';
    }else if (morse==11133){moji='3';
    }else if (morse==11113){moji='4';
    }else if (morse==11111){moji='5';
    }else if (morse==31111){moji='6';
    }else if (morse==33111){moji='7';
    }else if (morse==33311){moji='8';
    }else if (morse==33331){moji='9';
    }else if (morse==33333){moji='0';
    }else if (morse==131313){moji='.';
    }else if (morse==331133){moji=',';
    }else if (morse==333111){moji=':';
    }else if (morse==113311){moji='?';
    }else if (morse==311113){moji='-';
    }else if (morse==31331){moji='(';
    }else if (morse==313313){moji=')';
    }else if (morse==31131){moji='/';
    }else if (morse==31113){moji='=';
    }else if (morse==13131){moji='+';
    }else if (morse==131131){moji='"';
    }else if (morse==3113){moji='*';
    }else if (morse==133131){moji='@';
    }else{moji=' ';}
    return moji;
}



int main()
{
    //灰・1 黒ー2 赤enter
    init();

    for(;;) {
        if(input_log!=input) {
            lcd.locate(0, 1);
            //lcd.printf("%d\n",input);
            input_log=input;
        }
        
        if(button_short==0) {
            button_short_count+=1;
            if(button_short_count==chatter) {
                input = input*10 + 1;
                lcd.locate(input_cursor, 1);
                lcd.putc(0b10100101); 
                input_cursor++;
            }
        } else {
            button_short_count=0;
        }

        if(button_long==0) {
            button_long_count+=1;
            if(button_long_count==chatter) {
                input = input*10 + 3;
                lcd.locate(input_cursor, 1);
                lcd.putc('-'); 
                input_cursor++;
            }
        } else {
            button_long_count=0;
        }

        if(button_enter==0) {
            button_enter_count+=1;
            if(button_enter_count==chatter) {
                if(button_short_count>chatter && button_short_count>chatter) {
                    init();
                }else{       
                    //入力行     
                    lcd.locate(0, 1);
                    lcd.printf("               ");
                    //アルファベット表示行
                    lcd.locate(cursor, 0);
                    lcd.putc(morse_code(input));                                    
                    button_short_count=0;
                    button_long_count=0;
                    input=0;
                    input_log=0;
                    cursor++;
                    input_cursor=0;
                }
            }
        } else {
            button_enter_count=0;
        }
    }
}