#include "mbed.h"
#include "LSM9DS1.h"
#include "MadgwickAHRS.h"

RawSerial pc(USBTX, USBRX);

LSM9DS1 lsm = LSM9DS1(PB_5, PB_4, PB_3,PB_10,PA_8); //mosi,miso,sclk,cs_AG,cs_M
Ticker AHRS;
Ticker PRINT;
DigitalOut myled(LED1);
Madgwick filter = Madgwick();

void ahrs(){
    filter.update(lsm.gyro_y, lsm.gyro_x, lsm.gyro_z, lsm.accel_y, lsm.accel_x, lsm.accel_z ,lsm.mag_y, lsm.mag_x, lsm.mag_z);  
}

void print(){
    printf("roll:%f,pitch:%f,yaw:%f,accel_z:%f,gyro_z:%f,mag_x:%f\r\n", filter.getRoll(),filter.getPitch(),filter.getYaw(),lsm.accel_z, lsm.gyro_z,lsm.mag_x);
}

int main() {
    lsm.initSPI();
    lsm.initAccel(lsm.LSM9DS1_ACCELRANGE_8G);   //2,4,8,16
    lsm.initGyro(lsm.LSM9DS1_GYROSCALE_500DPS); //245,500,2000
    lsm.initMag(lsm.LSM9DS1_MAGGAIN_4GAUSS);    //4,8,12,16

    filter.begin(100); // N Hz
    AHRS.attach_us(&ahrs, 10000); // N us周期

    PRINT.attach(&print,1);

    while(1){
        lsm.readGyro();
        lsm.readAccel();
        lsm.readMag();
        wait(0.1);
    }
}