#include "necleo_pin.h"
#include "color.h"

#define L 0
#define H 1

#define R 0
#define G 1
#define B 2

class Dot{
    public:
        char red;
        char green;
        char blue;
        void SetColor(char r,char g,char b){
            red=r;
            green=g;
            blue=b;
        }
};

Dot led_board[16][16];

void ResetLEDBoard(){
    for(char i=0;i<16;i++){
        for(char j=0;j<16;j++){
            led_board[i][j].SetColor(CCLEAR);
        }
    }
}

void PrintLEDBoard(){
    static const char list[4]={0,2,1,3};
    static char count=0;
    CLK=L;
    LAT=L;
    for(char i=0;i<4;i++){
        OE=H;
        Address=list[i];
        for(char j=0;j<32;j++){
            if(j<8){
                Red1=led_board[i][7-j].red>count;
                Green1=led_board[i][7-j].green>count;
                Blue1=led_board[i][7-j].blue>count;
                Red2=led_board[i+8][7-j].red>count;
                Green2=led_board[i+8][7-j].green>count;
                Blue2=led_board[i+8][7-j].blue>count;
            }else if(j<16){
                Red1=led_board[i+4][j-8].red>count;
                Green1=led_board[i+4][j-8].green>count;
                Blue1=led_board[i+4][j-8].blue>count;
                Red2=led_board[i+12][j-8].red>count;
                Green2=led_board[i+12][j-8].green>count;
                Blue2=led_board[i+12][j-8].blue>count;
            }else if(j<24){
                Red1=led_board[i][31-j].red>count;
                Green1=led_board[i][31-j].green>count;
                Blue1=led_board[i][31-j].blue>count;
                Red2=led_board[i+8][31-j].red>count;
                Green2=led_board[i+8][31-j].green>count;
                Blue2=led_board[i+8][31-j].blue>count;
            }else{
                Red1=led_board[i+4][j-16].red>count;
                Green1=led_board[i+4][j-16].green>count;
                Blue1=led_board[i+4][j-16].blue>count;
                Red2=led_board[i+12][j-16].red>count;
                Green2=led_board[i+12][j-16].green>count;
                Blue2=led_board[i+12][j-16].blue>count;
            }
            CLK=H;
            CLK=L;
        }
        LAT=H;
        LAT=L;
        OE=L;
        wait_us(1);
    }
    OE=H;
    count++;
    if(count>100)count=0;
}