#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <vector>
#define EMPTY 0
#define BLACK 1
#define WHITE -1

class Board{
    public:
        int8_t board[8][8];
        int8_t turn;
        Board(){
            for(int8_t i=0;i<8;i++){
                for(int8_t j=0;j<8;j++)board[i][j]=EMPTY;
            }
            board[3][4]=BLACK;board[4][3]=BLACK;
            board[3][3]=WHITE;board[4][4]=WHITE;
            turn=BLACK;
        }
        void SetBoard(int8_t board[8][8]){
            memcpy(this->board,board,sizeof board);
        }
};

void SetLEDBoard(Board board);

/*void ResetBoard(){
    for(uint8_t i=0;i<8;i++){
        for(uint8_t j=0;j<8;j++)board[i][j]=EMPTY;
    }
    board[3][4]=BLACK;board[4][3]=BLACK;
    board[3][3]=WHITE;board[4][4]=WHITE;
}*/

bool CanRight(Board board,int8_t x,int8_t y,int8_t color){
    int8_t enemy=-color;
    if(x<=5&&board.board[x+1][y]==enemy){
        for(int8_t i=x+2;i<8;i++){
            if(board.board[i][y]==color)return true;
            else if(board.board[i][y]==EMPTY)break;
        }
    }
    return false;
}

bool CanLeft(Board board,int8_t x,int8_t y,int8_t color){
    int8_t enemy=-color;
    if(x>=2&&board.board[x-1][y]==enemy){
        for(int8_t i=x-2;i>=0;i--){
            if(board.board[i][y]==color)return true;
            else if(board.board[i][y]==EMPTY)break;
        }
    }
    return false;
}

bool CanUp(Board board,int8_t x,int8_t y,int8_t color){
    int8_t enemy=-color;
    if(y>=2&&board.board[x][y-1]==enemy){
        for(int8_t i=y-2;i>=0;i--){
            if(board.board[x][i]==color)return true;
            else if(board.board[x][i]==EMPTY)break;
        }
    }
    return false;
}

bool CanDown(Board board,int8_t x,int8_t y,int8_t color){
    int8_t enemy=-color;
    if(y<=5&&board.board[x][y+1]==enemy){
        for(int8_t i=y+2;i<8;i++){
            if(board.board[x][i]==color)return true;
            else if(board.board[x][i]==EMPTY)break;
        }
    }
    return false;
}

bool CanRightUp(Board board,int8_t x,int8_t y,int8_t color){
    int8_t enemy=-color;
    if(x<=5&&y>=2&&board.board[x+1][y-1]==enemy){
        int8_t i=2;
        while(x+i<8&&y-i>=0){
            if(board.board[x+i][y-i]==color)return true;
            else if(board.board[x+i][y-i]==EMPTY)break;
            i++;
        }
    }
    return false;
}

bool CanRightDown(Board board,int8_t x,int8_t y,int8_t color){
    int8_t enemy=-color;
    if(x<=5&&y<=5&&board.board[x+1][y+1]==enemy){
        int8_t i=2;
        while(x+i<8&&y+i<8){
            if(board.board[x+i][y+i]==color)return true;
            else if(board.board[x+i][y+i]==EMPTY)break;
            i++;
        }
    }
    return false;
}

bool CanLeftDown(Board board,int8_t x,int8_t y,int8_t color){
    int8_t enemy=-color;
    if(x>=2&&y<=5&&board.board[x-1][y+1]==enemy){
        int8_t i=2;
        while(x-i>=0&&y+i<8){
            if(board.board[x-i][y+i]==color)return true;
            else if(board.board[x-i][y+i]==EMPTY)break;
            i++;
        }
    }
    return false;
}

bool CanLeftUp(Board board,int8_t x,int8_t y,int8_t color){
    int8_t enemy=-color;
    if(x>=2&&y>=2&&board.board[x-1][y-1]==enemy){
        int8_t i=2;
        while(x-i>=0&&y-i>=0){
            if(board.board[x-i][y-i]==color)return true;
            else if(board.board[x-i][y-i]==EMPTY)break;
            i++;
        }
    }
    return false;
}

bool CanPut(Board board,int8_t x,int8_t y,int8_t color){
    return CanRight(board,x,y,color)||CanLeft(board,x,y,color)||CanUp(board,x,y,color)||CanDown(board,x,y,color)||CanRightUp(board,x,y,color)||CanRightDown(board,x,y,color)||CanLeftDown(board,x,y,color)||CanLeftUp(board,x,y,color);
}

std::vector<uint8_t> GetPutCoords(Board board,int8_t color){
    std::vector<uint8_t> coords;
    for(int8_t i=0;i<8;i++){
        for(int8_t j=0;j<8;j++){
            led_board[i+8][j+8].red=255;
            if(CanPut(board,i,j,color))coords.push_back(i*8+j);//ここの18回目の実行で上のCanDownからCanRightUpの間で止まる
        }
    }
    return coords;
}

Board PutStone(Board board,int8_t x,int8_t y,int8_t color){
    Board _dummyboard;
    int8_t dummyboard[8][8];
    int8_t enemy=-color;
    uint8_t i;
    memcpy(dummyboard,board.board,sizeof board.board);
    _dummyboard.SetBoard(dummyboard);
    if(CanRight(_dummyboard,x,y,color)){
        i=x+1;
        while(dummyboard[i][y]==enemy){
            dummyboard[i][y]=color;
            i+=1;
        }
    }
    if(CanLeft(_dummyboard,x,y,color)){
        i=x-1;
        while(dummyboard[i][y]==enemy){
            dummyboard[i][y]=color;
            i-=1;
        }
    }
    if(CanUp(_dummyboard,x,y,color)){
        i=y-1;
        while(dummyboard[x][i]==enemy){
            dummyboard[x][i]=color;
            i-=1;
        }
    }
    if(CanDown(_dummyboard,x,y,color)){
        i=y+1;
        while(dummyboard[x][i]==enemy){
            dummyboard[x][i]=color;
            i+=1;
        }
    }
    if(CanRightUp(_dummyboard,x,y,color)){
        i=1;
        while(dummyboard[x+i][y-i]==enemy){
            dummyboard[x+i][y-i]=color;
            i+=1;
        }
    }
    if(CanRightDown(_dummyboard,x,y,color)){
        i=1;
        while(dummyboard[x+i][y+i]==enemy){
            dummyboard[x+i][y+i]=color;
            i+=1;
        }
    }
    if(CanLeftDown(_dummyboard,x,y,color)){
        i=1;
        while(dummyboard[x-i][y+i]==enemy){
            dummyboard[x-i][y+i]=color;
            i+=1;
        }
    }
    if(CanLeftUp(_dummyboard,x,y,color)){
        i=1;
        while(dummyboard[x-i][y-i]==enemy){
            dummyboard[x-i][y-i]=color;
            i+=1;
        }
    }
    dummyboard[x][y]=color;
    _dummyboard.SetBoard(dummyboard);
    return _dummyboard;
}

uint8_t GetScore(Board board,int8_t color){
    uint8_t score=0;
    for(int8_t i=0;i<8;i++){
        for(int8_t j=0;j<8;j++){
            if(board.board[i][j]==color)score++;
        }
    }
    return score;
}


bool GameSet(Board board){
    led_board[8][0].red=255;
    std::vector<uint8_t> black(GetPutCoords(board,BLACK));
    std::vector<uint8_t> white(GetPutCoords(board,WHITE));
    led_board[0][8].red=255;
    return black.size()==0&&white.size()==0;
}