#include "necleo_pin.h"

#define L 0
#define H 1

#define R 0
#define G 1
#define B 2

class Dot{
    public:
        bool red;
        bool green;
        bool blue;
};

Dot led_board[16][16];

void ResetBoard(){
    for(char i=0;i<16;i++){
        for(char j=0;j<16;j++){
            led_board[i][j].red=false;
            led_board[i][j].green=false;
            led_board[i][j].blue=false;
        }
    }
}

void PrintBoard(){
    CLK=0;
    LAT=0;
    for(char i=0;i<4;i++){
        OE=H;
        Address=i;
        for(char j=0;j<32;j++){
            if(i<16){
                Red1=led_board[i][j].red;
                Green1=led_board[i][j].green;
                Blue1=led_board[i][j].blue;
                Red2=led_board[i+8][j].red;
                Green2=led_board[i+8][j].green;
                Blue2=led_board[i+8][j].blue;
            }else{
                Red1=led_board[i+4][j-16].red;
                Green1=led_board[i+4][j-16].green;
                Blue1=led_board[i+4][j-16].blue;
                Red2=led_board[i+12][j-16].red;
                Green2=led_board[i+12][j-16].green;
                Blue2=led_board[i+12][j-16].blue;
            }
            wait_us(10);
            CLK=H;
            wait_us(10);
            CLK=L;
        }
        wait_us(10);
        LAT=H;
        wait_us(10);
        LAT=L;
        OE=L;
        wait_us(100);
    }
}
/*class LED{
    public:
        char led_board[16][16];
        void ResetBoard(){
            for(char i=0;i<16;i++){
                for(char j=0;j<16;j++){
                    this->led_board[i][j]=1;
                }
            }
        }
        void ResetPin(){
            Address=0;
            OE=H;
            CLK=L;
            LAT=L;
        }
        void PrintLine(char board[16][16],char line){
            this->ResetPin();
            Address=line;
            for(char i=0;i<32;i++){
                if(i<16){
                    Red1=board[line][i]&R;
                    Green1=board[line][i]&G;
                    Blue1=board[line][i]&B;
                    Red2=board[line+8][i]&R;
                    Green2=board[line+8][i]&G;
                    Blue2=board[line+8][i]&B;
                }else{
                    Red1=board[line+4][i-16]&R;
                    Green1=board[line+4][i-16]&G;
                    Blue1=board[line+4][i-16]&B;
                    Red2=board[line+12][i-16]&R;
                    Green2=board[line+12][i-16]&G;
                    Blue2=board[line+12][i-16]&B;
                }                
                CLK=H;
                CLK=L;
            }
            LAT=H;
            LAT=L;
            OE=L; 
        }
        void PrintBoard(){
            for(char i=0;i<4;i++){
                PrintLine(this->led_board,i);
                wait_us(100);    
            }
        }
};*/