
#include <mbed.h>
#include "max6675_4.h"

max6675_4::max6675_4(SPI& _spi_4, PinName _ncs_4) : spi_4(_spi_4), ncs_4(_ncs_4) {

}

float max6675_4::read_temp_4() {
    short value_4 = 0;
    float temp_4 = 0;
    
    uint8_t highByte_4=0;
    uint8_t lowByte_4=0;
    
    select_4();
    wait(.25); //This delay is needed else it does'nt seem to update the temp

    highByte_4 = spi_4.write(0);
    lowByte_4 = spi_4.write(0);
    deselect_4();


    if (lowByte_4 & (1<<2)) {
        error("No Probe");
    } else {
        value_4 = (highByte_4 << 5 | lowByte_4>>3);
    }

    temp_4 = (value_4*0.25); // Multiply the value by 0.25 to get temp in ˚C or
                         //  * (9.0/5.0)) + 32.0;   // Convert value to ˚F (ensure proper floats!)

return temp_4;
}

void max6675_4::select_4() {
    ncs_4 = 0;
}

void max6675_4::deselect_4() {
    ncs_4 = 1;
}
