#include "mbed.h"
#include "max6675.h"
#include "max6675_2.h"
#include "max6675_3.h"
#include "max6675_4.h"
#include "SDFileSystem.h"
#include <time.h>
#include <stdio.h>

DigitalOut led_1(LED1);
DigitalOut led_2(LED2);
DigitalOut led_3(LED3);
DigitalOut led_4(LED4);
SPI spi(p11,p12,p13);
max6675 max(spi,p18);
SPI spi_2(p11,p12,p13);
max6675_2 max_2(spi_2,p21);
SPI spi_3(p11,p12,p13);
max6675_3 max_3(spi_3,p22);
SPI spi_4(p11,p12,p13);
max6675_4 max_4(spi_4,p23);
AnalogIn LM61(p15);
SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board
Serial pc(USBTX,USBRX);
DigitalIn swi_1(p24);   //p5～p30のどれでも良い
DigitalIn swi_2(p25);   //p5～p30のどれでも良い

void led()
{
   led_1 = 1;
   led_2 = 1;
   led_3 = 1;
   led_4 = 1;
   wait(.2);
   
   led_1 = 0;
   led_2 = 0;
   led_3 = 0;
   led_4 = 0;
   wait(.2);
   
   led_1 = 1;
   led_2 = 1;
   led_3 = 1;
   led_4 = 1;
   wait(.2);
   
   led_1 = 0;
   led_2 = 0;
   led_3 = 0;
   led_4 = 0;
   wait(.2);
}


int main() {
    int r = 5;  //平均する値の個数
   double w_h = .25; //加熱waitの時間
   double w_c = .25; //冷却waitの時間
   clock_t start_h;
   clock_t start_c;
   float tempC, sum, sum_2, sum_3, sum_4, ave, ave_2, ave_3, ave_4;
   int i, j, k, l;   //平均化処理に使用
   swi_1.mode(PullUp);
   swi_2.mode(PullUp);
    
   mkdir("/sd/mydir", 0777);
   printf("test start!\n");
    FILE *fp = fopen("/sd/mydir/test_heating.csv", "a");
            if(fp == NULL) 
               { error("Could not open file for write\n");
               }
               
           fprintf(fp, "t,T_1,T_2,T_3,T_4,tempC\n");
           fclose(fp); 
    /*FILE *fp =*/ fopen("/sd/mydir/test_cooling.csv", "a");
            if(fp == NULL) 
               { error("Could not open file for write\n");
               }
               
           fprintf(fp, "t,T_1,T_2,T_3,T_4,tempC\n");
           fclose(fp); 
   
  
   if( swi_1 == 1 && swi_2 == 0 )  //スイッチをマイコンのUSBと逆方向に倒したとき
     {
       printf("\n\n\nheating start\n\n\n");
      
       led();
       
       while (1)
        {
           start_h = clock();
             printf("%f\n", (double)start_h/CLOCKS_PER_SEC);
           
            max.select();                       
            max_2.deselect_2();
            max_3.deselect_3();
            max_4.deselect_4();
 
          //平均化処理      
          
            sum = 0;
            ave = 0;
            i = 0;
           for( i = 0; i < r; i++)            
             {
              float temp = max.read_temp();
              sum += temp;
             }   
            
            ave = sum / r;
            printf("\n\rT: %f",ave );
            
            
           
            max.deselect();
            max_2.select_2();
            max_3.deselect_3();
            max_4.deselect_4();
             
        //平均化処理  
            sum_2 = 0;
            ave_2 = 0;
            j = 0;
           for( j = 0; j < r; j++)            
           {
              float temp_2 = max_2.read_temp_2();
              sum_2 += temp_2;
           }   
            
            ave_2 = sum_2 / r;
            printf("\n\rT: %f",ave_2 );
            
            
            
          max.deselect();
          max_2.deselect_2();
          max_3.select_3();
          max_4.deselect_4();
          
          //平均化処理
            sum_3 = 0;
            ave_3 = 0;
            k = 0;
            for( k = 0; k < r; k++)
            {
                float temp_3 = max_3.read_temp_3();
                sum_3 += temp_3;
            }
            
            ave_3 = sum_3 / r;
            printf("\n\rT: %f",ave_3 );
            
            
            
            max.deselect();
            max_2.deselect_2();
            max_3.deselect_3();
            max_4.select_4();
            
            //平均化処理
                sum_4 = 0;
                ave_4 =0;
                l = 0;
                for( l = 0; l < r; l++)
                {
                    float temp_4 = max_4.read_temp_4();
                    sum_4 += temp_4;
            }
            
            ave_4 = sum_4 / r;
            printf("\n\rT: %f",ave_4 );
            
             //conversion to degrees C - from sensor output voltage per LM61 data sheet
            tempC = ((LM61*3.3)-0.600)*100.0;
           
            printf("\nC: %5.2F \n\n\n\r", tempC);
              
            /*FILE *fp =*/ fopen("/sd/mydir/test_heating.csv", "a");
            if(fp == NULL) 
               { error("Could not open file for write\n");
               }
               
           fprintf(fp, "%f,%f,%f,%f,%f,%f\n",(double)start_h/CLOCKS_PER_SEC, ave, ave_2, ave_3,ave_4, tempC);
           fclose(fp); 
           wait(w_h);
        }//while_h
    
     }//if_h
     
     
     if( swi_1 == 0 && swi_2 == 1 ) //スイッチをマイコンのUSBの方向に倒したとき
      {   
         printf("\n\n\ncolling start\n\n\n");
         
         led();
         
        while (1)
         {
            start_c = clock();
            printf("%f\n", (double)start_c/CLOCKS_PER_SEC);
   //        double sum_time = start_h/CLOCKS_PER_SEC + start_c/CLOCKS_PER_SEC;
   //         printf("%f\n", sum_time);
          
           

            max.select();
            max_2.deselect_2();
            max_3.deselect_3();
            max_4.deselect_4();
 
          //平均化処理      
          
            sum = 0;
            ave = 0;
            i = 0;
           for( i = 0; i < r; i++)            
             {
              float temp = max.read_temp();
              sum += temp;
             }   
            
            ave = sum / r;
            printf("\n\rT: %f",ave );
            
            
           

            max.deselect();
            max_2.select_2();
            max_3.deselect_3();
            max_4.deselect_4();
             
        //平均化処理  
            sum_2 = 0;
            ave_2 = 0;
            j = 0;
           for( j = 0; j < r; j++)            
           {
              float temp_2 = max_2.read_temp_2();
              sum_2 += temp_2;
           }   
            
            ave_2 = sum_2 / r;
            printf("\n\rT: %f",ave_2 );
            
            
            
            max.deselect();
            max_2.deselect_2();
            max_3.select_3();
            max_4.deselect_4();
             
        //平均化処理  
            sum_3 = 0;
            ave_3 = 0;
            k = 0;
           for( k = 0; k < r; k++)            
           {
              float temp_3 = max_3.read_temp_3();
              sum_3 += temp_3;
           }   
            
            ave_3 = sum_3 / r;
            printf("\n\rT: %f",ave_3 );
            
            
            
            max.deselect();
            max_2.deselect_2();
            max_3.deselect_3();
            max_4.select_4();
             
        //平均化処理  
            sum_4 = 0;
            ave_4 = 0;
            l = 0;
           for( l = 0; l < r; l++)            
           {
              float temp_4 = max_4.read_temp_4();
              sum_4 += temp_4;
           }   
            
            ave_4 = sum_4 / r;
            printf("\n\rT: %f",ave_4 );
            
             //conversion to degrees C - from sensor output voltage per LM61 data sheet
            tempC = ((LM61*3.3)-0.600)*100.0;
           
            printf("\nC: %5.2F \n\n\n\r", tempC);
              
            /*FILE *fp = */fopen("/sd/mydir/test_cooling.csv", "a");
            if(fp == NULL) 
               { error("Could not open file for write\n");
               }
        
           fprintf(fp, "%f,%f,%f,%f,%f,%f\n",(double)start_c/CLOCKS_PER_SEC, ave, ave_2, ave_3,ave_4, tempC);
           fclose(fp); 
           wait(w_c);
        }//while_c
    
     }//if_c
     
     
      if( swi_1 == 1 && swi_2 == 1 )  // スイッチを倒さない時（真ん中の時）
         { 
           led();
           printf("\n\n\nsotp\n\n\n");
         }
         
} //main()

