
#include <mbed.h>
#include "max6675_3.h"

max6675_3::max6675_3(SPI& _spi_3, PinName _ncs_3) : spi_3(_spi_3), ncs_3(_ncs_3) {

}

float max6675_3::read_temp_3() {
    short value_3 = 0;
    float temp_3 = 0;
    
    uint8_t highByte_3=0;
    uint8_t lowByte_3=0;
    
    select_3();
    wait(.25); //This delay is needed else it does'nt seem to update the temp

    highByte_3 = spi_3.write(0);
    lowByte_3 = spi_3.write(0);
    deselect_3();


    if (lowByte_3 & (1<<2)) {
        error("No Probe");
    } else {
        value_3 = (highByte_3 << 5 | lowByte_3>>3);
    }

    temp_3 = (value_3*0.25); // Multiply the value by 0.25 to get temp in ˚C or
                         //  * (9.0/5.0)) + 32.0;   // Convert value to ˚F (ensure proper floats!)

return temp_3;
}

void max6675_3::select_3() {
    ncs_3 = 0;
}

void max6675_3::deselect_3() {
    ncs_3 = 1;
}