
#include <mbed.h>
#include "max6675_2.h"

max6675_2::max6675_2(SPI& _spi_2, PinName _ncs_2) : spi_2(_spi_2), ncs_2(_ncs_2) {

}

float max6675_2::read_temp_2() {
    short value_2 = 0;
    float temp_2 = 0;
    
    uint8_t highByte_2=0;
    uint8_t lowByte_2=0;
    
    select_2();
    wait(.25); //This delay is needed else it does'nt seem to update the temp

    highByte_2 = spi_2.write(0);
    lowByte_2 = spi_2.write(0);
    deselect_2();


    if (lowByte_2 & (1<<2)) {
        error("No Probe");
    } else {
        value_2 = (highByte_2 << 5 | lowByte_2>>3);
    }

    temp_2 = (value_2*0.25); // Multiply the value by 0.25 to get temp in ˚C or
                         //  * (9.0/5.0)) + 32.0;   // Convert value to ˚F (ensure proper floats!)

return temp_2;
}

void max6675_2::select_2() {
    ncs_2 = 0;
}

void max6675_2::deselect_2() {
    ncs_2 = 1;
}
