//20200803 Kikkawa モタコン基板(緑色ver.1)での動作確認済み
//BLDC, INA226, CAN

#include "mbed.h"
#include "BLDCmotorDriver.h"
#include "INA226.hpp"
  
/*定数の設定*/
#define Vin1_LENGTH 20   //要素数(個数指定用の定数)
#define Cin1_LENGTH 20   //要素数(個数指定用の定数)
#define canSlaveID 0x10     //CAN通信IDを0x10に設定

CAN canSlave(p30, p29);
Timer timer;        //回転数計算用タイマ設定
Ticker ticker1;     //割り込み設定用
Ticker ticker2;     //割り込み設定用

Serial pc(USBTX, USBRX);
BLDCmotorDriver M(p26, p24, p22, p25, p23, p21, p9, p8, p7, LED1);
AnalogIn Pot(p20);
DigitalIn direction(p16);
DigitalIn accel(p15);

DigitalOut led2(LED2);  //CAN_check
DigitalOut led3(LED3);  //direction_check
DigitalOut led4(LED4);  //accel_check

double rpm = 0.0, speed = 0.0;   //モータ回転数、速度
float dc = 0.0, dc_limit = 0.0;
int sector = 0;

bool flagPrintf = 0;    //main関数でのprintf処理のため

int forSend = 0;        //データ送信時に一時的に使用する変数
bool CANsendOK = 0;  //CAN受信完了時,セットする(mainでのprintfのため)
CANMessage msgSlave;    //CAN送信用
void Handler_canSlaveSend();

/*INA226関係*/    //GNDGND(G-G):0x80, Vs+Vs+(1-1):0x8A, SDASDA(D-D):0x94, SCLSCL(C-C):0x9E, GNDVs+(G-1):0x82
I2C i2c(p28,p27);
void initINA226();  //INA226の初期設定を行う関数
void INA226_init(); //INA226の初期設定用関数
INA226 VCmonitor(i2c); 
unsigned short val;
double V,C;
int count = 1;      //INA226動作確認用カウンタ
float data_Vin1[Vin1_LENGTH] = {0.0, 0.0, 0.0, 0.0, 0.0};        //一時的データ格納配列
float data_Cin1[Cin1_LENGTH] = {0.0, 0.0, 0.0, 0.0, 0.0};        //一時的データ格納配列
void get_VCipm(void);   //IPMの電圧電流計測関数

void Handler_canSlaveSend() {
    forSend = (int)(V/100);
    msgSlave.data[0] = forSend / 100;    //forSend / 100 = 15あまり43 となり,答えの方がデータ格納される
    msgSlave.data[1] = forSend % 100;    //forSend / 100 = 15あまり43 となり,あまりの方がデータ格納される
    
    forSend = (int)(C/10);  //mAで取得した値を10で割り、char2分割で送り切れるようにする。(例: 測定電流が199.99Aのとき,C=199900.00となるため,forSend=19990となり,199と90で分割することで送信できる)
    msgSlave.data[2] = forSend / 100;   //forSend / 100 = 5あまり54 となり,答えの方がデータ格納される
    msgSlave.data[3] = forSend % 100;   //forSend % 100 = 5あまり54 となり,あまりの方がデータ格納される
    
    forSend = (int)(speed*10);  //speed * 10 = 856.5だが,intにするため,856が代入される 
    msgSlave.data[4] = forSend / 100;   //forSend / 100 = 8あまり56 となり,8がデータ格納される
    msgSlave.data[5] = forSend % 100;   //forSend % 100 = 8あまり56 となり,56がデータ格納される
    
    forSend = (int)(dc*100);  //dc * 100 = 95
    msgSlave.data[6] = forSend;   //charの最大値である255以下になるため,そのままデータ格納される
    
    if(canSlave.write(msgSlave)){   //格納したデータを送信する
        CANsendOK = 1;
    }
}
/*
void Handler_canSlaveRecieve(){ //canMasterから送信要求が来たとき,データ送信するための関数
    if( canSlave.read( msgSlave ) ){ //msgに送られたデータが入る   
        led2 = !led2;
        if( msgSlave.id == canSlaveID ){ //IDがcanSlaveIDであれば処理する   
            Handler_canSlaveSend(); //送信処理を開始する
        }
    }
}
*/
void INA226_init(){ //INA226初期設定を行う関数
    printf("\n\r");
    printf("VCmonitor INA226 TEST Program. (BUILD:[" __DATE__ "/" __TIME__ "])\n\r");
    if(!VCmonitor.isExist()){ pc.printf("VCmonitor NOT FOUND "); }
    val = 0;
    if(VCmonitor.rawRead(0x00,&val) != 0){ pc.printf("VCmonitor READ ERROR "); }    //configResisterの値を読み取れるか確認(通信できてるか確認)
    VCmonitor.setConfigResister();  //configurationResisterの設定
    printf("VCmonitor Reg 0x00 : 0x%04x\n\r",val);  //configResisterの値表示
    printf("\n\r");
    VCmonitor.setCurrentCalibration();  //calibrationResisterの設定
}    

int main() {
    /*ポート初期設定*/
    direction.mode(PullUp);                //進行方向スイッチ入力ピンをプルアップに設定
    accel.mode(PullUp);                //アクセルスイッチ入力ピンをプルアップに設定
    
    /*INA226初期設定*/
    INA226_init();  //INA226の初期設定する関数に飛ぶ
    
    /*CAN初期設定*/
//    canSlave.attach(&Handler_canSlaveRecieve, CAN::RxIrq);   //CAN受信割り込みの設定
    msgSlave.id = canSlaveID; //CAN送信側(slave)のIDを決定
    msgSlave.len = 7;   //CAN送信側で送るデータのバイト数
       
    while(true) {  
        dc = ( Pot.read()-0.5 )*2;  //可変抵抗の値からduty比を設定
//        dc_limit = -0.0147 * speed * speed + 2.6842 * speed + 29.885;    //加速側制限.elsxの式
//        dc = dc * dc_limit;
        
        VCmonitor.getVoltage(&V);   //IPM電圧(mV)測定
        VCmonitor.getCurrent(&C);   //IPM電流(mA)測定
        
        if( !accel.read() ){
            led4 = 0;
            M.setDutyCycle(0);     //duty比の設定 duty比を0にする
        }
        if( accel.read() ){
            if( !direction.read() ){    //directionスイッチが0のとき
                led3 = 0;               //処理
            }
            else if( direction.read() ){     //directionスイッチが1のとき
                led3 = 1;
            }
            led4 = 1;
            M.setDutyCycle(dc);     //duty比の設定
            sector = M.getSector();
            //get_VCipm();    //Vin1とCin1を取得する
            //pc.printf("HS_cnt: %d HS_usec %d\n", M.HS_cnt, M.HS_usec);  //デバッグ用            
        }
        rpm = 3750 / (M.HS_usec * 0.001);   //ミリ秒に直して逆数を3750に掛けるああ  //BLDCmotorDriver.cpp(.h)で使っている変数をmainで使う場合は「M.」を付ける。「M」なのはmainの上の方でそう設定してるから。usecはmicro second:マイクロ秒
        speed = rpm * 0.10518;                  //3750とか0.010518は、excelで計算している。ファイル名「」
        pc.printf("Duty: %.2f, Sector: %d, %.1f km/h, rpm: %1.2f, V: %.0f, C: %.0f\n\r",dc, sector, speed, rpm, V, C);
        Handler_canSlaveSend(); //送信処理を開始する
    }
}