/* Monitoring System Program
*   @Kikkawa
*   @ver.1 2020/04/05, ver.2 2020/04/05
*
*   LCD(20*4), LCD(デカ文字,SB1602E), CAN, USBmemory, indicator, hazard, horn
*/
#include "mbed.h"
#include "TextLCD.h"    //LCD(4*20)ライブラリ
#include "SB1602E.h"    //LCD(デカ文字)ライブラリ
#include "MSCFileSystem.h"  //USBメモリのライブラリ

DigitalOut myled(LED1);
DigitalOut myled1(LED2);
DigitalOut myled2(LED3);
DigitalOut myled3(LED4);

/*インパネ周りの設定*/
Ticker flipper0;
DigitalOut overCharge(p22);     //過充電LED点灯用
DigitalOut overDisCharge(p23);  //過放電LED点灯用
DigitalOut winkR_Out(p5);   //ウィンカー右_出力
DigitalOut winkL_Out(p6);   //ウィンカー左_出力
DigitalOut horn_Out(p8);    //ホーン_出力
DigitalOut brake_Out(p7);    //ブレーキ_出力
InterruptIn P_SW(p24);    //Pボタン_入力(テレメトリ送信とかUSBメモリ保存ファイル切り替えとかに使用予定)
InterruptIn winkR_SW(p21);  //ウィンカー右スイッチ入力    kiban5
InterruptIn winkL_SW(p10);   //ウィンカー左スイッチ入力
InterruptIn horn_SW(p12);    //ホーンスイッチ入力
InterruptIn hazard_SW(p11);  //ハザードスイッチ入力
InterruptIn brake_SW(p9);  //ブレーキ入力
bool P_SW_pre = 0;
bool winkR_SW_pre = 0;
bool winkL_SW_pre = 0;
bool hazard_SW_pre = 0;
void toukarui_init(void);

/*LCD(20*4)の設定 (lcd1)*/
TextLCD lcd1(p15, p16, p17, p18, p19, p20);  // RS, E, DB4, DB5, DB6, DB7
void lcd1_printf(void);  //LCDに文字表示する関数
int lcd1_cnt = 0;

/*LCD(デカ文字)の設定 (lcd2)*/
I2C i2c( p28, p27 );
SB1602E lcd2( i2c );    //  SDA, SCL
int lcd2_cnt = 0;

/*USBメモリの設定*/
MSCFileSystem msc("usb"); // Mount flash drive under the name "msc"
void MSC_init(void);   //USBの初期設定関数
void write_MSC(void);   //USBへデータを書き込む関数
FILE *fp;    


void winker_flip() {
    if( hazard_SW_pre ) {
        myled1 = !myled1;
        myled2 = !myled2;
    }
    else if( winkL_SW_pre ) {
        myled1 = !myled1;
    }
    else if( winkR_SW_pre ){
        myled2 = !myled2;
    }
    else {
        myled1 = 0;
        myled2 = 0;
    }
}

void P_SW_handler() {
    P_SW_pre = !P_SW_pre;
}

void winkR_SW_handler() {
    winkR_SW_pre = !winkR_SW_pre;
}

void winkL_SW_handler() {
    winkL_SW_pre = !winkL_SW_pre;
}

void hazard_SW_handler() {
    hazard_SW_pre = !hazard_SW_pre;
    winkR_SW_pre = 0;
    winkL_SW_pre = 0;
    myled1 = 0;
    myled2 = 0;
}

void horn_SW_handler() {
    if( !horn_SW.read() ){  //ホーンSWを押しているとき
        myled3 = 1;
        horn_Out = 1;
    }
    else {  //ホーンSWを離しているとき
        myled3 = 0;
        horn_Out = 0;
    }
}

void lcd1_printf(){
    lcd1.locate(0, 1);
    lcd1.printf( "%d", lcd1_cnt );
}

void lcd2_printf(){
    lcd2.printf( 0, "Hello world!\r" );    //  line# (0 or 1), string
//    lcd2.printf( 1, " %d\r", lcd1_cnt, lcd1_cnt, lcd1_cnt );   // \rがないと座標が右にシフトしていく
//    lcd2.printf( 1, "%d %d %d\r", lcd1_cnt, lcd1_cnt, lcd1_cnt );   // \rがないと座標が右にシフトしていく
//    lcd2.printf( 1, "%d %d %d\r", lcd1_cnt, lcd1_cnt, lcd1_cnt );   // \rがないと座標が右にシフトしていく

}

void MSC_init(){    //USBメモリの初期設定関数
    fp = fopen( "/usb/test.csv", "a");    //ファイルを開く   "W"は新規作成して書き込み,"a"は上書き(Fileなければ新規作成書き込み)
    printf("USB fileopen0!\r\n");
    if ( fp == NULL ) {
        printf("USBmemory ERROR!\r\n");
        exit(1);
    }
    fprintf(fp,"a,b,c,d,e,f,g\n");   //ファイル書き込み
    fclose(fp);                 //ファイルを閉じる  
    printf("USB file close!\n");
}

void write_MSC(){   //USBメモリにデータ書き込む関数
    if ( (fp= fopen( "/usb/MPPT.csv", "a")) == NULL ){  //ファイルを開く, aは上書きの命令(ファイルが存在しなければ新規作成する)
        printf("USB error\r\n");
        exit(1);
    }
//    fprintf(fp,"%f,%f,%f,%f,%f,%f\n", Vin1, Cin1, Vout1, Vout1, temp1, temp2);  //ファイル書き込み
    fclose(fp);         //ファイルを閉じる  
}

void toukarui_init(){
    P_SW.mode( PullUp );    //  内蔵プルアップを使う
    winkR_SW.mode( PullUp );    //  内蔵プルアップを使う
    winkL_SW.mode( PullUp );    //  内蔵プルアップを使う
    horn_SW.mode( PullUp );    //  内蔵プルアップを使う
    hazard_SW.mode( PullUp );    //  内蔵プルアップを使う
    
    P_SW.rise(&P_SW_handler);   //立ち下がり割り込みを設定
    winkR_SW.rise(&winkR_SW_handler);   //立ち上がり割り込みを設定
    winkL_SW.rise(&winkL_SW_handler);   //立ち上がり割り込みを設定
    horn_SW.fall(&horn_SW_handler);   //立ち上がり割り込みを設定
    horn_SW.rise(&horn_SW_handler);   //立ち上がり割り込みを設定
    hazard_SW.rise(&hazard_SW_handler);   //立ち上がり割り込みを設定
    
    flipper0.attach(&winker_flip, 0.67); // the address of the function to be attached (flip) and the interval (2 seconds)
}

int main() {
    wait(0.001);
    lcd1.cls();
    wait(0.001);
    lcd1.locate(0, 0);
    lcd1.printf( "Hello world!");
    
    MSC_init(); //USBメモリ初期化
    toukarui_init();
    while(1) {
        lcd1_printf();   //LCD(20*4)への文字表示をする関数
        lcd2_printf();   //LCD(デカ文字)への文字表示をする関数
        lcd1_cnt++;
        
        write_MSC();    //USBメモリへ書き込む関数
        wait(1.0);
    }
}
