//BLDC, INA226, CAN

#include "mbed.h"
#include "RateLimiter.h"
#include "BLDCmotorDriver.h"
#include "INA226.hpp"
  
/*定数の設定*/
#define Vin1_LENGTH 20   //要素数(個数指定用の定数)
#define Cin1_LENGTH 20   //要素数(個数指定用の定数)
#define time1 1

CAN canSlave(p30, p29);


Timer timer;        //回転数計算用タイマ設定
Ticker ticker1;     //割り込み設定用
Ticker ticker2;     //割り込み設定用

RateLimiter rl;

Serial pc(USBTX, USBRX);
BLDCmotorDriver M(p26, p24, p22, p25, p23, p21, p14, p17, p18, LED1);
AnalogIn Pot(p20);
InterruptIn HS_p16(p16);    
InterruptIn sw(p8);

DigitalOut led2(LED2);
DigitalOut led3(LED3);

int voltage = 0;
int begin, end;
int HS_timer = 0;
int HS_timer1 = 0;
int reset_cnt = 0;

float rpm = 0, speed = 0;
double dc = 0.0;
int DS = 0;


bool flagPrintf = 0;    //main関数でのprintf処理のため

int forSend = 0;        //データ送信時に一時的に使用する変数
bool CANsendOK = 0;  //CAN受信完了時,セットする(mainでのprintfのため)
CANMessage msgSlave;    //CAN送信用
unsigned int  canSlaveID = 0x10;   //canSlaveの初期IDを0x10に設定
void Handler_canSlaveSend();

int n = 0;  //移動平均算出に使うカウンタ

/*INA226関係*/    //GNDGND(G-G):0x80, Vs+Vs+(1-1):0x8A, SDASDA(D-D):0x94, SCLSCL(C-C):0x9E, GNDVs+(G-1):0x82
I2C i2c(p28,p27);
void initINA226();  //INA226の初期設定を行う関数
void INA226_init(); //INA226の初期設定用関数
INA226 VCmonitor(i2c); 
unsigned short val;
double V,C,Vin1,Cin1,Vout1,Cout1;
int count = 1;      //INA226動作確認用カウンタ
float data_Vin1[Vin1_LENGTH] = {0.0, 0.0, 0.0, 0.0, 0.0};        //一時的データ格納配列
float data_Cin1[Cin1_LENGTH] = {0.0, 0.0, 0.0, 0.0, 0.0};        //一時的データ格納配列

void get_VCin1(void);
void get_VCout1(void);

void Handler_canSlaveSend() {
    forSend = (int)(Vin1/100);
    msgSlave.data[0] = forSend / 100;    //forSend / 100 = 15あまり43 となり,答えの方がデータ格納される
    msgSlave.data[1] = forSend % 100;    //forSend / 100 = 15あまり43 となり,あまりの方がデータ格納される
    
    forSend = (int)(Cin1/10);  //mAで取得した値を10で割り、char2分割で送り切れるようにする。(例: 測定電流が199.99Aのとき,C=199900.00となるため,forSend=19990となり,199と90で分割することで送信できる)
    msgSlave.data[2] = forSend / 100;   //forSend / 100 = 5あまり54 となり,答えの方がデータ格納される
    msgSlave.data[3] = forSend % 100;   //forSend % 100 = 5あまり54 となり,あまりの方がデータ格納される
    
    forSend = (int)(speed*10);  //speed * 10 = 856.5だが,intにするため,856が代入される 
    msgSlave.data[4] = forSend / 100;   //forSend / 100 = 8あまり56 となり,8がデータ格納される
    msgSlave.data[5] = forSend % 100;   //forSend % 100 = 8あまり56 となり,56がデータ格納される
    
    forSend = (int)(dc*100);  //dc * 100 = 95
    msgSlave.data[6] = forSend;   //charの最大値である255以下になるため,そのままデータ格納される
    
    if(canSlave.write(msgSlave)){   //格納したデータを送信する
        CANsendOK = 1;
    }
}

void Handler_canSlaveRecieve(){ //canMasterから送信要求が来たとき,データ送信するための関数
    if( canSlave.read( msgSlave ) ){ //msgに送られたデータが入る   
        led2 = !led2;
        if( msgSlave.id == canSlaveID ){ //IDがcanSlaveIDであれば処理する   
            Handler_canSlaveSend(); //送信処理を開始する
        }
    }
}
void handler_0t2s(){   //0.2秒毎の割り込み
//    dc = Pot.read();   
    if( !DS ){
        dc = Pot.read()-0.5;
        dc = dc * 2;
        if( dc <= -0.3 ){    //回生の制限
            dc = -0.3;
        }
    }
    else if( DS ){
        dc = Pot.read()-0.5;
        dc = dc * -2;
        if( dc >= 0.3 ){    //回生の制限
            dc = 0.3;
        }
    }
    reset_cnt++;
  //  flagPrintf = 1;
    if( reset_cnt >= 6000 ){
        timer.reset();
        reset_cnt = 0;
    }
}

void handler_directionSW(){
    if( DS && dc >= 0 ){
        DS = 0; //前進
        dc = -0.5;
        rl.reset();
    }
    else if( !DS && dc <= 0 ){
        DS = 1;
        dc = 0.5;
        rl.reset();
    }
}

void handler_HS(){  //ホールセンサの立ち上がりから立ち上がりまでの時間計測
    if( HS_timer == 0 ){
        begin = timer.read_us();
        HS_timer1 = 0;
    }
    if( HS_timer == 1 ){
        end = timer.read_us();
        HS_timer1 = 1;
    }
    if( HS_timer1 == 0 ){
        HS_timer = 1;
    }
    if( HS_timer1 == 1 ){
        HS_timer = 0;
        rpm = 3750 / (abs(end - begin) * 0.001);
        speed = rpm * 0.10518;
    }
}  


void INA226_init(){ //INA226初期設定を行う関数
    pc.printf("VCmonitor INA226 TEST Program. (BUILD:[" __DATE__ "/" __TIME__ "])\n");
    if(!VCmonitor.isExist()){
        pc.printf("VCmonitor NOT FOUND\n");
//        while(1){;}
    }
    val = 0;
    if(VCmonitor.rawRead(0x00,&val) != 0){
        pc.printf("VCmonitor READ ERROR\n");
//        while(1){;}
    }
    pc.printf("VCmonitor Reg 0x00 : 0x%04x\n",val);
    VCmonitor.setCurrentCalibration();
}    

void get_VCin1(){
    if((VCmonitor.getVoltage(&V) == 0) && (VCmonitor.getCurrent(&C) == 0)){     //1台目INA226の電圧電流測定
        Vin1 -= data_Vin1[n];    //3行で移動平均を算出できる
        Cin1 -= data_Cin1[n];    //3行で移動平均を算出できる
        data_Vin1[n] = V/Vin1_LENGTH;
        data_Cin1[n] = C/Cin1_LENGTH;
        Vin1 += data_Vin1[n];
        Cin1 += data_Cin1[n];
        pc.printf("\n, Vin1: %f, Cin1: %f\n",Vin1,Cin1);
    }
}
int main() {
    pc.printf("Press 'w' to speed up, 's' to speed down\n\r");
    ticker1.attach(&handler_0t2s, 0.3); //0.3秒毎にhandler_0t2s関数に飛ぶ
    //ticker2.attach(&handler_1t0s, 1); //1秒毎にhandler_1t0s関数に飛ぶ
    
    sw.mode(PullUp);                //directionスイッチのモード設定
    sw.fall(&handler_directionSW);  //directionスイッチの立ち上がり割り込み設定
    sw.rise(&handler_directionSW);  //directionスイッチの立ち下がり割り込み設定
    led3 = sw.read();
    
    HS_p16.rise(&handler_HS);       //ホールセンサ立ち上がり割り込み設定
    timer.start();      //回転数計算用タイマスタート
    led2 = 1;
    
    INA226_init();  //INA226の初期設定
    canSlave.attach(&Handler_canSlaveRecieve, CAN::RxIrq);   //CAN受信割り込みの設定
    msgSlave.id = canSlaveID; //CAN送信側(slave)のIDを決定
    msgSlave.len = 7;   //CAN送信側で送るデータのバイト数
       
    while(true) {  
        M.setDutyCycle(dc);     //duty比の設定
        M.setDirection(DS);     //DS:DirectionSW
        get_VCin1();    //Vin1とCin1を取得する

        n++;
        if( n >= Vin1_LENGTH ){ //カウンタがサンプル数を超えたら,0に戻り,移動平均算出を続ける           
            n = 0;
        }
 //       if( flagPrintf ){   //flagPrntfが1なら,以下を処理する
 //           flagPrintf = 0;
            pc.printf("Duty Cycle: %1.2f, Sector: %d\n\r",dc, M.getSector());
            pc.printf("Toggle the led takes %d us\n", abs(end - begin));
            pc.printf("%f rpm\n",rpm);
            pc.printf("%f km/h\n",speed);
            pc.printf("V,%f,C,%f\n",V,C);
   //     }

    }
}
