#include "mbed.h"
#include "bq769x0.h"
#include "INA226.hpp"

Timer timer1;

Serial pc(USBTX,USBRX);
I2C i2c(p9, p10);                              // SDA SCL
bq769x0 bms( i2c, p26, 3, 0x18, false);
I2C i2c_ina226(p28,p27);
INA226 VCmonitor(i2c_ina226);
CAN can(p30,p29);
char counte=0;
CANMessage CANbuf;

AnalogIn tempSens1(p16);                         // set p15 to analog input to read LM61 sensor's voltage output
AnalogIn tempSens2(p17);                         // set p15 to analog input to read LM61 sensor's voltage output
AnalogIn tempSens3(p18);                         // set p15 to analog input to read LM61 sensor's voltage output
AnalogIn tempSens4(p19);                         // set p15 to analog input to read LM61 sensor's voltage output
AnalogIn tempSens5(p20);                         // set p15 to analog input to read LM61 sensor's voltage output
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

float temp1, temp2, temp3, temp4, temp5;
int cellVolt1[15];                              //int cellVolt1[15]; /mv
int cellVolt2[15];                              //int cellVolt1[15]; /mv
int cellMax1;
int cellMin1;
int cellAve1;
int cellMax2;
int cellMin2;
int cellAve2;
int cellMax0;
int cellMin0;
int cellAve0;

int sum1 = 0;
int sum2 = 0;

void readTemp(void);

int main(){
    pc.printf("main program start\n\r");
    bms.init1();
    bms.init2();
    wait(1);
    
    CANbuf.id = 0x30; //CAN送信側(slave)のIDを決定

    //INA226の処理
    unsigned short val=0;
    double C;
    int count = 1;
    if(!VCmonitor.isExist()){
        pc.printf("VCmonitor NOT FOUND\n");
        while(1){;}
    }
    pc.printf("VCmonitor FOUND\n\r");
    if(VCmonitor.rawRead(0x00,&val) != 0){  //configResisterの値を読み取れるか確認(通信できてるか確認)
        pc.printf("VCmonitor READ ERROR\n");
    }
    VCmonitor.setConfigResister();
    wait(0.1);
    pc.printf("VCmonitor Reg 0x00 : 0x%04x\n\r",val);  //configResisterの値表示
    VCmonitor.setCurrentCalibration();
    
    //無限ループ開始
    while(1){
        bms.update1();                              //1-15セル電圧の測定
        //wait(0.5);
        sum1 = 0;
        for( int i=1; i<=15; i++ ){                 //1-15セルの電圧を格納する処理
            cellVolt1[i-1] = bms.getCellVoltage(i); //cellVolt1配列に値を格納
            sum1 = sum1 + cellVolt1[i-1];           //合計を算出(バッテリ電圧・セル平均電圧の算出に使用)
        }
        cellMax1 = bms.getMaxCellVoltage();         //1-15セルの最大セル電圧を格納
        cellMin1 = bms.getMinCellVoltage();         //1-15セルの最小セル電圧を格納
        cellAve1 = sum1/15;                         //1-15セルの平均セル電圧を格納
        pc.printf("max1:%d, ave1:%d, min1:%d\n\r", cellMax1, cellAve1, cellMin1 );
        pc.printf("cell1:%d,%d,%d,%d,%d %d,%d,%d,%d,%d %d,%d,%d,%d,%d\n\r",
            cellVolt1[0],cellVolt1[1],cellVolt1[2],cellVolt1[3],cellVolt1[4], cellVolt1[5],cellVolt1[6],cellVolt1[7],cellVolt1[8],cellVolt1[9], cellVolt1[10],cellVolt1[11],cellVolt1[12],cellVolt1[13],cellVolt1[14]);
        //pc.printf("\n\r");
        bms.update2();                              //16-27セル電圧の測定
        //wait(0.5);
        sum2 = 0;
        for( int i=1; i<=15; i++ ){                 //16-27セルの電圧を格納する処理
            cellVolt2[i-1] = bms.getCellVoltage(i); //
            sum2 = sum2 + cellVolt2[i-1];
        }
        sum2 = sum2 -(cellVolt2[3]+cellVolt2[8]+cellVolt2[13]);     //4セル,9セル,14セルは未接続のため値を引く  
        cellAve2 = sum2/12;                                         //16-27セルの平均セル電圧を格納
        cellMax2 = bms.getMaxCellVoltage();                         //16-27セルの最大セル電圧を格納
        cellMin2 = bms.getMinCellVoltage();                         //16-27セルの最小セル電圧を格納
        pc.printf("max2:%d, ave2:%d, min2:%d\n\r", cellMax2, cellAve2, cellMin2 );
        pc.printf("cell2:%d,%d,%d,%d,%d %d,%d,%d,%d,%d %d,%d,%d,%d,%d\n\r",
            cellVolt2[0],cellVolt2[1],cellVolt2[2],cellVolt2[3],cellVolt2[4], cellVolt2[5],cellVolt2[6],cellVolt2[7],cellVolt2[8],cellVolt2[9], cellVolt2[10],cellVolt2[11],cellVolt2[12],cellVolt2[13],cellVolt2[14]);
        
        if(cellMax1 >= cellMax2){
            cellMax0 = cellMax1;            //27セル中の最大セル電圧を格納
        }else if(cellMax1 < cellMax2){
            cellMax0 = cellMax2;            //27セル中の最大セル電圧を格納
        }
        if(cellMin1 <= cellMin2){
            cellMin0 = cellMin1;            //27セル中の最小セル電圧を格納
        }else if(cellMin1 > cellMin2){
            cellMin0 = cellMin2;            //27セル中の最小セル電圧を格納
        }
        cellAve0 = (sum1 + sum2) / 27;      //27セルの平均セル電圧を格納
        pc.printf("%d, %d, %d\n\r", sum1, sum2, sum1+sum2);
        //温度を測定する処理
        temp1 = ((tempSens1*3.3)-0.600)*100.0;      //conversion to degrees C - from sensor output voltage per LM61 data sheet
        temp2 = ((tempSens2*3.3)-0.600)*100.0;      //conversion to degrees C - from sensor output voltage per LM61 data sheet
        temp3 = ((tempSens3*3.3)-0.600)*100.0;      //conversion to degrees C - from sensor output voltage per LM61 data sheet
        temp4 = ((tempSens4*3.3)-0.600)*100.0;      //conversion to degrees C - from sensor output voltage per LM61 data sheet
        temp5 = ((tempSens5*3.3)-0.600)*100.0;      //conversion to degrees C - from sensor output voltage per LM61 data sheet
        pc.printf("temp:%4.1f,%4.1f,%4.1f,%4.1f,%4.1f\n\r",temp1,temp2,temp3,temp4,temp5);     //print current temp
        //pc.printf("\n\r");
        
        //バッテリ電流を測定する処理
        //VCmonitor.getVoltage(&V);
        //V = V * 14.825;
        VCmonitor.getCurrent(&C);
        pc.printf("%d,C,%f\n\r",count,C);
        pc.printf("\n\r");

        CANbuf.data[0] = ((sum1+sum2)/100) / 100;
        CANbuf.data[1] = ((sum1+sum2)/100) % 100;
        CANbuf.data[2] = ((int)(C/10) / 100);
        CANbuf.data[3] = ((int)(C/10) % 100);
        CANbuf.data[4] = cellMin0 / 1000;
        CANbuf.data[5] = (cellMin0 % 1000) / 10;
        CANbuf.data[6] = cellMax0 / 1000;
        CANbuf.data[7] = (cellMax0 % 1000) / 10;
        if(can.write(CANbuf)){              //格納したデータを送信する
            led1 = !led1;
        }
    }   
}