#include "mbed.h"
#include "bms.h"

SPI spi(p5,p6, p7);
DigitalOut cs(p8);

void cs_low(void)
{
    cs=0;
}

void cs_high(void)
{
    cs=1;
}

void delay_u(uint16_t micro)
{
    wait_us(micro);
}

void delay_m(uint16_t milli)
{
    wait_ms(milli);
}

void spi_enable(void) // Configures SCK frequency. Use constant defined in header file.
{
    //printf("takuma");
    cs = 1;                     //high as init for disable SPI
    spi.format(8, 3);               //byte width, spi mode
    spi.frequency(1000000);         //1MHz
    
}
    

/*
Writes an array of bytes out of the SPI port
*/

void spi_write_array(uint8_t len, // Option: Number of bytes to be written on the SPI port
                     uint8_t data[] //Array of bytes to be written on the SPI port
                    )
{
    //cs=0;
    for (uint8_t i = 0; i < len; i++) {
        spi.write((int8_t)data[i]);
    }
    //cs=1;
}

/*
 Writes and read a set number of bytes using the SPI port.

*/

void spi_write_read(uint8_t tx_Data[],//array of data to be written on SPI port
                    uint8_t tx_len, //length of the tx data arry
                    uint8_t *rx_data,//Input: array that will store the data read by the SPI port
                    uint8_t rx_len //Option: number of bytes to be read from the SPI port
                   )
{
    //cs=0;
    for (uint8_t i = 0; i < tx_len; i++) {
        spi.write(tx_Data[i]);
    }
    //cs=1;

    //cs=0;
    for (uint8_t i = 0; i < rx_len; i++) {

        rx_data[i] = (uint8_t)spi.write(0xFF);
    }
    //cs=1;

}


uint8_t spi_read_byte(uint8_t tx_dat)
{
    uint8_t data;
    //cs=0;
    data = (uint8_t)spi.write(0xFF);
    //cs=1;
    return(data);
}
