#include "mbed.h"
#include "SNIC_WifiInterface.h"
#include "HTTPClient.h"

#define WIFI_SSID           ""
#define WIFI_SECUTIRY_KEY   ""
//#define WIFI_SECURITY_TYPE  e_SEC_OPEN
//#define WIFI_SECURITY_TYPE  e_SEC_WEP
//#define WIFI_SECURITY_TYPE  e_SEC_WPA_TKIP
#define WIFI_SECURITY_TYPE  e_SEC_WPA2_AES
//#define WIFI_SECURITY_TYPE  e_SEC_WPA2_MIXED
//#define WIFI_SECURITY_TYPE  e_SEC_WPA_AES

#define MAX_SENSING_SEC 60
#define INTERVAL_SEC     3

#define MAX_SITE 7
char *twitter_url[MAX_SITE]= {
    "http://192.168.0.1:3000/tweet_count?url=http://au-fx.kddi.com/",
    "http://192.168.0.1:3000/tweet_count?url=http://www.au.kddi.com/",
    "http://192.168.0.1:3000/tweet_count?url=http://www.kddi.com/",
    "http://192.168.0.1:3000/tweet_count?url=http://www.kddilabs.jp/",
    "http://192.168.0.1:3000/tweet_count?url=http://www.mozilla.org/",
    "http://192.168.0.1:3000/tweet_count?url=http://www.apple.com/",
    "http://192.168.0.1:3000/tweet_count?url=http://www.google.com/"
};

#define THRESHOLD1 100
#define THRESHOLD2 1000
#define THRESHOLD3 10000


DigitalOut led[]={LED1,LED2,LED3,LED4};

#if defined(TARGET_LPC1768)
C_SNIC_WifiInterface wifi( p13, p14, p12, p11, p20 );
Serial pc(USBTX, USBRX);    // This is required when defined "_DEBUG"
#else
#error no defined pin.
#endif


int connect()
{
    char str[512];
    
    pc.printf("----------------\n");
    pc.printf("Murata TypeYD - HTTPClient example\n");

    //wifi init
    int ret = wifi.init();
    if (!ret) {
        printf("Initialized\n");
    } else {
        printf("Error wifi.init() - ret = %d\n", ret);
        return -1;
    }
    wait(0.5);

    //wifi disconnect for sure of wifi init
    ret = wifi.disconnect();
    wait(0.5);

    //get wifi firm ware version
    ret = wifi.getFWVersion((unsigned char *)str);
    if (!ret) {
        printf("Firmware version: %s\n", str);
    } else {
        printf("Error wifi.getFWVersion() - ret = %d\n", ret);
        return -1;
    }
    wait(0.5);

    //wifi settings
    ret = wifi.connect( WIFI_SSID, strlen(WIFI_SSID)
                        , WIFI_SECURITY_TYPE
                        , WIFI_SECUTIRY_KEY, strlen(WIFI_SECUTIRY_KEY) );
    if (!ret) {
        printf("Wifi Connected\n");
    } else {
        printf("Error wifi.connect() - ret = %d\n", ret);
        return -1;
    }

    // Use DHCP
    wifi.setIPConfig( true );
    //wifi.setIPConfig( false, "192.168.0.48", "255.255.255.0", "192.168.0.1" );
    wait(0.5);
    
    return 0;
}


void disconnect(){
    int ret = wifi.disconnect();
    if (!ret) {
        printf("Disconnected\n");
    } else {
        printf("Error wifi.disconnect() - ret = %d\n", ret);
    }
    while(1) {
    }
}


void output_result(const char* count)
{
    int i;
    long value;
    char *endp;
    
    for(i=0; i<4; i++){ led[i] = 0; }
    
    if(!count || count[0] == '\0'){
        return;
    }
    
    value = strtol(count, &endp, 10);
    if(*endp != '\0'){
        return;
    }
    
    if(value > 0){
        led[0] = (value > 0);
        led[1] = (value > THRESHOLD1);
        led[2] = (value > THRESHOLD2);
        led[3] = (value > THRESHOLD3);
    }
}


int main()
{
    char count[11];
    int ret, i = 0;
    HTTPClient http;
    Ticker ticker; 
    
    //for debug setting
    pc.baud( 115200 ); //for debug setting

    if(connect() < 0){
        return -1;
    }    
    
    led[0] = 1;
    
    ticker.attach(&disconnect, MAX_SENSING_SEC);// interrupt disconnect method running after MAX_SENSING_SEC

    // GET data
    while(1){
        printf("\r\nTrying to GET request...\r\n");
        i = rand() % MAX_SITE;
        ret = http.get(twitter_url[i], count, sizeof(count) - 1);
        if (!ret) {
            printf("Page fetched successfully - read %d characters\r\n", strlen(count));
            printf("Tweet Count: %s\r\n", count);
            
            output_result(count);            
        } else {
            printf("Error - ret = %d - HTTP return code = %d\r\n", ret, http.getHTTPResponseCode());
        }
        
        wait(INTERVAL_SEC);
    }
}
