#include "mbed.h"
#include "SNIC_WifiInterface.h"
#include "TCPSocketServer.h"

#if defined(TARGET_LPC1768)
#include "PowerControl/EthernetPowerControl.h"
#endif

#define ECHO_SERVER_PORT   7

#define DEMO_AP_SSID                  "SSID"
#define DEMO_AP_SECURITY_TYPE         e_SEC_WPA2_AES
#define DEMO_AP_SECUTIRY_KEY          "PASSWORD"

C_SNIC_WifiInterface     wifi( p9, p10, NC, NC, p30 );

int main (void) {
#if defined(TARGET_LPC1768)
    PHY_PowerDown();
#endif

    wifi.init(); //Use DHCP

    wait(0.5);
    int s = wifi.disconnect();
    if( s != 0 )
    {
        return -1;
    }    
    
    wait(0.3);
    // Connect AP
    wifi.connect( DEMO_AP_SSID
                        , strlen(DEMO_AP_SSID)
                        , DEMO_AP_SECURITY_TYPE
                        , DEMO_AP_SECUTIRY_KEY
                        , strlen(DEMO_AP_SECUTIRY_KEY) );
    wait(0.5);
    
    wifi.setIPConfig( true );    
    wait(0.5);
    
    printf("IP Address is %s\n", wifi.getIPAddress());
    
    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();    

    while (true) {
        printf("\nWait for new connection...\n");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 1500); // Timeout after (1.5)s
        
        printf("Connection from: %s\n", client.get_address());
        char buffer[256];
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;
            
            client.send_all(buffer, n);
            if (n <= 0) break;
        }
        
        client.close();
    }
}
