#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"
#include "DxClient.h"

#define PULSE_ON 0.0011 
#define PULSE_OFF 0.0018 
#define PULSE_NU 0.0015 

#define GLUINSERVER "ws://xxx.yyy.zzz/dx"

PwmOut servo(p21);
AnalogIn noise(p15);

DigitalOut  led_connect(LED1);
DigitalOut  led_error(LED2);

bool last_ctrl = false;
bool bUpdate = false;

extern "C" void mbed_mac_address(char *mac);

 
static bool device_get( dx_props *props)
{
    printf("device_get is called, but do nothing\n");
    return false;
}
static bool device_set( dx_props *props)
{
    printf("device_set is called\n");
    
    if (props->numofprops>0) {
        printf("%s: %s\n", props->props[0].name, props->props[0].b_val?"true":"false");
    
        bool ctrl = props->props[0].b_val;
        if (last_ctrl != ctrl) {
            if (ctrl) {
                servo.pulsewidth(PULSE_ON); // servo position determined by a pulsewidth between 1-2ms
                wait(0.5f);
                servo.pulsewidth(PULSE_NU); // servo position determined by a pulsewidth between 1-2ms
            } else {
                servo.pulsewidth(PULSE_OFF); // servo position determined by a pulsewidth between 1-2ms
                wait(0.5f);
                servo.pulsewidth(PULSE_NU); // servo position determined by a pulsewidth between 1-2ms
            }
            last_ctrl = ctrl;
            bUpdate = true;
        }
        return true;
    }
    return false;
}

 
int main() 
{
    // init servo
    servo.period(0.020);          // servo requires a 20ms period
    servo.pulsewidth(PULSE_NU); // servo position determined by a pulsewidth between 1-2ms

    led_connect = 0;
    led_error = 0;
    
    // ethernet initialize   
    EthernetInterface ethernet;
    ethernet.init();    // connect with DHCP
    int ret_val = ethernet.connect();
    if (0 == ret_val) {
        printf("IP Address: %s\n", ethernet.getIPAddress());
    } else {
        error("ethernet failed to connect: %d.\n", ret_val);
        led_error = 1;
    }

    //  get mac address for generationg deviceid
    char mac[6];
    char deviceid[32];
    mbed_mac_address(mac);
    sprintf( deviceid, "device-%02X-%02X-%02X-%02X-%02X-%02X", mac[0],mac[1],mac[2],mac[3],mac[4],mac[5] );
    printf( "deviceid: %s\n", deviceid );

   
    // connect to server
    bool res; 
    DxClient dxc(GLUINSERVER, deviceid, noise.read_u16());
    
    dxc.set_user("USER","PASS");
    dxc.set_device_description("manipulator to control Swithes");
    dxc.set_device_name("manipulator");
    dxc.set_get_requset_handler( device_get );
    dxc.set_set_requset_handler( device_set );
    res = dxc.connect();
    if (!res) {
        led_error = 1;
        return -1;
    }
    led_connect = 1;
    
    //  device registration
    dx_props props;
    
    props.numofprops = 1;
    props.props = (dx_prop*)malloc( sizeof(dx_prop) * props.numofprops );
    sprintf( props.props[0].name, "manipulator" );
    props.props[0].type = DX_BOOLEAN;
    props.props[0].mode = DX_WRITEONLY;
    props.props[0].direction = DX_UPDOWN;
    props.props[0].b_val = false;
    
    res = dxc.register_device( &props );
    if (!res) {
        return -1;
    }
    
    while(1){
        //  send sensor values periodically
        for(int i=0;i<0x7fffffff;i++) {
    
            // pool message from server for set and get request
            dxc.handle_messages();
            if (bUpdate) {
                props.props[0].b_val = last_ctrl;
                dxc.update_device(&props);
                bUpdate = false;
            }
            wait(0.1f);
    
            // send keep alive message at a inverval        
            if (i%30==0) {
                dxc.keepalive_device();
            }
        }
    }
    
    res = dxc.deregister_device();

    free( props.props );
    
    dxc.deregister_device();
    dxc.close();
    ethernet.disconnect();

    while(true);
}

