#include "mbed.h"
#include "SNIC_WifiInterface.h"
#include "HTTPClient.h"

/* set this */
#define POST_URL "http://192.168.0.1:3000/set_temp"

#define WIFI_SSID           ""
#define WIFI_SECUTIRY_KEY   ""
//#define WIFI_SECURITY_TYPE  e_SEC_OPEN
//#define WIFI_SECURITY_TYPE  e_SEC_WEP
//#define WIFI_SECURITY_TYPE  e_SEC_WPA_TKIP
#define WIFI_SECURITY_TYPE  e_SEC_WPA2_AES
//#define WIFI_SECURITY_TYPE  e_SEC_WPA2_MIXED
//#define WIFI_SECURITY_TYPE  e_SEC_WPA_AES

#define MAX_SENSOR_DATA  40.0
#define MIN_SENSOR_DATA -10.0

#define MAX_SENSING_SEC 60
#define INTERVAL_SEC     3


DigitalOut led[]={LED1,LED2,LED3,LED4};

#if defined(TARGET_LPC1768)
C_SNIC_WifiInterface wifi( p13, p14, p12, p11, p20 );
Serial pc(USBTX, USBRX);    // This is required when defined "_DEBUG"
#else
#error no defined pin.
#endif


int connect()
{
    char str[512];
    
    pc.printf("----------------\n");
    pc.printf("Murata TypeYD - HTTPClient example\n");

    //wifi init
    int ret = wifi.init();
    if (!ret) {
        printf("Initialized\n");
    } else {
        printf("Error wifi.init() - ret = %d\n", ret);
        return -1;
    }
    wait(0.5);

    //wifi disconnect for sure of wifi init
    ret = wifi.disconnect();
    wait(0.5);

    //get wifi firm ware version
    ret = wifi.getFWVersion((unsigned char *)str);
    if (!ret) {
        printf("Firmware version: %s\n", str);
    } else {
        printf("Error wifi.getFWVersion() - ret = %d\n", ret);
        return -1;
    }
    wait(0.5);

    //wifi settings
    ret = wifi.connect( WIFI_SSID, strlen(WIFI_SSID)
                        , WIFI_SECURITY_TYPE
                        , WIFI_SECUTIRY_KEY, strlen(WIFI_SECUTIRY_KEY) );
    if (!ret) {
        printf("Wifi Connected\n");
    } else {
        printf("Error wifi.connect() - ret = %d\n", ret);
        return -1;
    }

    // Use DHCP
    wifi.setIPConfig( true );
    //wifi.setIPConfig( false, "192.168.0.48", "255.255.255.0", "192.168.0.1" );
    wait(0.5);
    
    return 0;
}


void disconnect(){
    int ret = wifi.disconnect();
    if (!ret) {
        printf("Disconnected\n");
    } else {
        printf("Error wifi.disconnect() - ret = %d\n", ret);
    }
    while(1) {
    }
}


void getSensorData(char* sensor_data)
{
    float value = 0;
    
    /* get sensor value, change this. */
    value = MIN_SENSOR_DATA + (float)(rand()*(MAX_SENSOR_DATA-MIN_SENSOR_DATA+1.0)/(1.0+RAND_MAX));
    
    sprintf(sensor_data, "%.1f", value);
}


int main()
{
    char str[512], sensor_data[10];
    int ret, i = 0;
    HTTPClient http;
    HTTPText inText(str, sizeof(str));
    Ticker ticker; 
    
    //for debug setting
    pc.baud( 115200 );

    if(connect() < 0){
        return -1;
    }
    
    led[0] = 1;
    
    ticker.attach(&disconnect, MAX_SENSING_SEC);// interrupt disconnect method running after MAX_SENSING_SEC

    // POST data
    while(1){
        getSensorData(sensor_data);
        HTTPText outText(sensor_data);
        printf("\r\nTrying to POST request...\r\n");
        ret = http.post(POST_URL, outText, &inText);
        if (!ret) {
            printf("Executed POST successfully - read %d characters\r\n", strlen(str));
            printf("Result: %s\r\n", str);
        } else {
            printf("Error - ret = %d - HTTP return code = %d\r\n", ret, http.getHTTPResponseCode());
        }
        
        led[i++ & 0x3] = 0;
        led[i   & 0x3] = 1;

        wait(INTERVAL_SEC);
    }
}
